/*
 * Decompiled with CFR 0.152.
 */
package xin.altitude.cms.word.util;

import freemarker.template.Configuration;
import freemarker.template.Template;
import freemarker.template.TemplateException;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import xin.altitude.cms.common.util.MD5Utils;
import xin.altitude.cms.common.util.ServletUtils;
import xin.altitude.cms.word.util.CommonDocUtils;

public class DocUtils {
    private static final String KEY = "data";
    private static final String SUFFIX = ".doc";

    public static <T> void fillWord(String path, Map<String, T> dataMap, String ... fileName) {
        String templateContent = CommonDocUtils.readTemplate(path);
        String content = DocUtils.doProcess(templateContent, dataMap, new Configuration[0]);
        DocUtils.returnWord(content, fileName);
    }

    public static <T> void fillWord(String path, T data, String ... fileName) {
        Map<String, T> dataMap = DocUtils.createMap(data);
        String templateContent = CommonDocUtils.readTemplate(path);
        String content = DocUtils.doProcess(templateContent, dataMap, new Configuration[0]);
        DocUtils.returnWord(content, fileName);
    }

    private static <T> Map<String, T> createMap(T data) {
        HashMap<String, T> dataMap = new HashMap<String, T>();
        dataMap.put(KEY, data);
        return dataMap;
    }

    public static <T> void fillWord(String path, List<T> data, String ... fileName) {
        Map<String, List<T>> dataMap = DocUtils.createMap(data);
        String templateContent = CommonDocUtils.readTemplate(path);
        String content = DocUtils.doProcess(templateContent, dataMap, new Configuration[0]);
        DocUtils.returnWord(content, fileName);
    }

    private static <T> Map<String, List<T>> createMap(List<T> data) {
        HashMap<String, List<T>> dataMap = new HashMap<String, List<T>>();
        dataMap.put(KEY, data);
        return dataMap;
    }

    public static <T> void fillXml(String path, T data) {
        Map<String, T> dataMap = DocUtils.createMap(data);
        String templateContent = CommonDocUtils.readTemplate(path);
        String content = DocUtils.doProcess(templateContent, dataMap, new Configuration[0]);
        DocUtils.returnXml(content);
    }

    public static <T> void fillXml(String path, List<T> data) {
        Map<String, List<T>> dataMap = DocUtils.createMap(data);
        String templateContent = CommonDocUtils.readTemplate(path);
        String content = DocUtils.doProcess(templateContent, dataMap, new Configuration[0]);
        DocUtils.returnXml(content);
    }

    public static <T> String resolveString(String path, List<T> data) {
        Map<String, List<T>> dataMap = DocUtils.createMap(data);
        String templateContent = CommonDocUtils.readTemplate(path);
        return DocUtils.doProcess(templateContent, dataMap, new Configuration[0]);
    }

    public static <T> String resolveString(String path, T data) {
        Map<String, T> dataMap = DocUtils.createMap(data);
        String templateContent = CommonDocUtils.readTemplate(path);
        return DocUtils.doProcess(templateContent, dataMap, new Configuration[0]);
    }

    public static void returnXml(String text) {
        HttpServletResponse response = ServletUtils.getResponse();
        try {
            response.setContentType("text/xml");
            response.getOutputStream().write(text.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void returnWord(String text, String ... fileName) {
        HttpServletResponse response = ServletUtils.getResponse();
        String content = null;
        response.setContentType("application/msword");
        if (fileName.length == 0) {
            content = "attachment; filename=" + System.currentTimeMillis() + SUFFIX;
        } else {
            try {
                content = "attachment; filename=" + URLEncoder.encode(fileName[0] + SUFFIX, StandardCharsets.UTF_8.name());
            }
            catch (UnsupportedEncodingException e) {
                e.printStackTrace();
            }
        }
        response.setHeader("Content-Disposition", content);
        try {
            response.getOutputStream().write(text.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static <T> String doProcess(String templateContent, Map<String, T> dataMap, Configuration ... configuration) {
        if (templateContent == null) {
            throw new RuntimeException("\u6a21\u7248\u89e3\u6790\u5f02\u5e38!");
        }
        if (configuration.length == 0) {
            configuration = new Configuration[]{new Configuration()};
        }
        StringWriter out = new StringWriter();
        try {
            String name = MD5Utils.md5((String)templateContent);
            new Template(name, (Reader)new StringReader(templateContent), configuration[0]).process(dataMap, (Writer)out);
        }
        catch (TemplateException | IOException e) {
            e.printStackTrace();
        }
        return out.toString();
    }
}

