/*
 * Decompiled with CFR 0.152.
 */
package xin.altitude.cms.common.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.springframework.aop.framework.AopContext;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.NoSuchBeanDefinitionException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.lang.NonNull;

@ConditionalOnMissingBean(value={SpringUtils.class})
public class SpringUtils
implements BeanFactoryPostProcessor,
ApplicationContextAware {
    private static ConfigurableListableBeanFactory beanFactory;
    private static ApplicationContext applicationContext;

    private SpringUtils() {
    }

    public static <T> T getBean(String name) throws BeansException {
        return (T)beanFactory.getBean(name);
    }

    public static <T> T getBean(Class<T> clazz) throws BeansException {
        Object result = beanFactory.getBean(clazz);
        return (T)result;
    }

    public static <T> List<T> getBeans(Class<T> clazz) {
        ArrayList list = new ArrayList();
        Map beansOfType = applicationContext.getBeansOfType(clazz);
        beansOfType.forEach((k, v) -> list.add(v));
        return list;
    }

    public static boolean containsBean(String name) {
        return beanFactory.containsBean(name);
    }

    public static boolean isSingleton(String name) throws NoSuchBeanDefinitionException {
        return beanFactory.isSingleton(name);
    }

    public static Class<?> getType(String name) throws NoSuchBeanDefinitionException {
        return beanFactory.getType(name);
    }

    public static String[] getAliases(String name) throws NoSuchBeanDefinitionException {
        return beanFactory.getAliases(name);
    }

    public static <T> T getAopProxy(T invoker) {
        return (T)AopContext.currentProxy();
    }

    public static String[] getActiveProfiles() {
        return applicationContext.getEnvironment().getActiveProfiles();
    }

    public static String getActiveProfile() {
        String[] activeProfiles = SpringUtils.getActiveProfiles();
        return activeProfiles.length > 0 ? activeProfiles[0] : null;
    }

    public void postProcessBeanFactory(@NonNull ConfigurableListableBeanFactory beanFactory) throws BeansException {
        SpringUtils.beanFactory = beanFactory;
    }

    public void setApplicationContext(@NonNull ApplicationContext applicationContext) throws BeansException {
        SpringUtils.applicationContext = applicationContext;
    }
}

