/*
 * Decompiled with CFR 0.152.
 */
package xin.altitude.cms.common.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Optional;
import org.apache.commons.io.IOUtils;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import xin.altitude.cms.common.util.StringUtil;

public class ResourceUtils {
    private static final PathMatchingResourcePatternResolver RESOLVER = new PathMatchingResourcePatternResolver();

    private ResourceUtils() {
    }

    public static Resource[] resolveMapperLocations(String locations) {
        Optional<String> optional = Optional.ofNullable(locations);
        if (optional.isPresent()) {
            return ResourceUtils.resolveMapperLocations(StringUtil.split((String)locations, (String)","));
        }
        return new Resource[0];
    }

    public static Resource[] resolveMapperLocations(String[] locations) {
        ArrayList resources = new ArrayList();
        if (locations != null) {
            Arrays.stream(locations).forEach(mapperLocation -> {
                try {
                    resources.addAll(Arrays.asList(RESOLVER.getResources(mapperLocation)));
                }
                catch (IOException ioException) {
                    ioException.printStackTrace();
                }
            });
        }
        return resources.toArray(new Resource[0]);
    }

    public static Resource resolveConfigLocation(String configLocation) {
        return RESOLVER.getResource(configLocation);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readFileContent(String fileLocation) {
        try (InputStream is = ResourceUtils.resolveConfigLocation(fileLocation).getInputStream();){
            StringWriter sw = new StringWriter();
            IOUtils.copy((InputStream)is, (Writer)sw, (Charset)StandardCharsets.UTF_8);
            String string = sw.toString();
            return string;
        }
        catch (IOException e) {
            throw new RuntimeException(String.format("\u76f8\u5bf9\u8def\u5f84{%s}\u6587\u4ef6\u8bfb\u53d6\u5931\u8d25", fileLocation));
        }
    }
}

