/*
 * Decompiled with CFR 0.152.
 */
package xin.altitude.cms.common.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.BoundSetOperations;
import org.springframework.data.redis.core.HashOperations;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import xin.altitude.cms.common.util.JacksonUtils;
import xin.altitude.cms.common.util.MapUtils;
import xin.altitude.cms.common.util.SpringUtils;

public class RedisUtils {
    private static final Logger logger = LoggerFactory.getLogger(RedisUtils.class);
    private static final StringRedisTemplate STRING_REDIS_TEMPLATE = SpringUtils.getBean(StringRedisTemplate.class);
    private static final ValueOperations<String, String> OPS_FOR_VALUE = STRING_REDIS_TEMPLATE.opsForValue();

    public static void save(String key, Object value) {
        if (value instanceof String) {
            OPS_FOR_VALUE.set((Object)key, (Object)((String)value));
        } else {
            Optional.ofNullable(JacksonUtils.writeValue(value)).ifPresent(e -> OPS_FOR_VALUE.set((Object)key, e));
        }
    }

    public static void save(String key, Object value, int sec) {
        RedisUtils.save(key, value, sec, TimeUnit.SECONDS);
    }

    public static void save(String key, Object value, long timeout, TimeUnit timeUnit) {
        if (value instanceof String) {
            OPS_FOR_VALUE.set((Object)key, (Object)((String)value), timeout, timeUnit);
        } else {
            Optional.ofNullable(JacksonUtils.writeValue(value)).ifPresent(e -> OPS_FOR_VALUE.set((Object)key, e, timeout, timeUnit));
        }
    }

    public static <V> void saveBatch(Map<String, V> map) {
        Map<String, String> transMap = MapUtils.transMap(map, JacksonUtils::writeValue);
        OPS_FOR_VALUE.multiSet(transMap);
    }

    public static <V> void saveBatch(Map<String, V> map, int timeout, TimeUnit timeUnit) {
        Map<String, String> transMap = MapUtils.transMap(map, JacksonUtils::writeValue);
        OPS_FOR_VALUE.multiSet(transMap);
    }

    public static Boolean saveIfAbsent(String key, Object value) {
        if (value instanceof String) {
            return OPS_FOR_VALUE.setIfAbsent((Object)key, (Object)((String)value));
        }
        return Optional.ofNullable(JacksonUtils.writeValue(value)).map(e -> OPS_FOR_VALUE.setIfAbsent((Object)key, e)).orElse(false);
    }

    public static Boolean saveIfAbsent(String key, Object value, Integer sec) {
        return RedisUtils.saveIfAbsent(key, value, sec.intValue(), TimeUnit.SECONDS);
    }

    public static Boolean saveIfAbsent(String key, Object value, long timeout, TimeUnit timeUnit) {
        long min = Long.min(timeout, 0L);
        if (value instanceof String) {
            return OPS_FOR_VALUE.setIfAbsent((Object)key, (Object)((String)value), min, timeUnit);
        }
        return Optional.ofNullable(JacksonUtils.writeValue(value)).map(e -> OPS_FOR_VALUE.setIfAbsent((Object)key, e, min, timeUnit)).orElse(false);
    }

    public static Boolean expire(String key, Long sec) {
        return RedisUtils.expire(key, sec, TimeUnit.SECONDS);
    }

    public static Boolean expire(String key, Long timeout, TimeUnit unit) {
        return STRING_REDIS_TEMPLATE.expire((Object)key, timeout.longValue(), unit);
    }

    public static <T> T getObject(String key, Class<T> clazz) {
        return Optional.ofNullable(OPS_FOR_VALUE.get((Object)key)).map(e -> JacksonUtils.readObjectValue(e, clazz)).orElse(null);
    }

    public static <T> List<T> getList(String key, Class<T> clazz) {
        return Optional.ofNullable(OPS_FOR_VALUE.get((Object)key)).map(e -> JacksonUtils.readListValue(e, clazz)).orElse(Collections.emptyList());
    }

    public static Boolean remove(String key) {
        return STRING_REDIS_TEMPLATE.delete((Object)key);
    }

    public static Long remove(Collection<String> keys) {
        return STRING_REDIS_TEMPLATE.delete(keys);
    }

    public static Set<String> getCacheSet(String key) {
        return STRING_REDIS_TEMPLATE.opsForSet().members((Object)key);
    }

    public static Long setCacheList(String key, List<String> dataList) {
        Long count = STRING_REDIS_TEMPLATE.opsForList().rightPushAll((Object)key, dataList);
        return count == null ? 0L : count;
    }

    public static BoundSetOperations<String, String> setCacheSet(String key, Set<String> dataSet) {
        BoundSetOperations setOperation = STRING_REDIS_TEMPLATE.boundSetOps((Object)key);
        for (String s : dataSet) {
            setOperation.add((Object[])new String[]{s});
        }
        return setOperation;
    }

    public static void setCacheMap(String key, Map<String, String> dataMap) {
        if (dataMap != null) {
            STRING_REDIS_TEMPLATE.opsForHash().putAll((Object)key, dataMap);
        }
    }

    public static Map<Object, Object> getCacheMap(String key) {
        return STRING_REDIS_TEMPLATE.opsForHash().entries((Object)key);
    }

    public static void setCacheMapValue(String key, String hKey, String value) {
        STRING_REDIS_TEMPLATE.opsForHash().put((Object)key, (Object)hKey, (Object)value);
    }

    public static String getCacheMapValue(String key, String hKey) {
        HashOperations opsForHash = STRING_REDIS_TEMPLATE.opsForHash();
        return (String)opsForHash.get((Object)key, (Object)hKey);
    }

    public static void delCacheMapValue(String key, String hkey) {
        HashOperations hashOperations = STRING_REDIS_TEMPLATE.opsForHash();
        hashOperations.delete((Object)key, new Object[]{hkey});
    }

    public static Collection<String> keys(String pattern) {
        return STRING_REDIS_TEMPLATE.keys((Object)pattern);
    }

    public static void publishMsg(String channelName, Object msg) {
        if (msg instanceof String) {
            STRING_REDIS_TEMPLATE.convertAndSend(channelName, msg);
        } else {
            try {
                String json = SpringUtils.getBean(ObjectMapper.class).writeValueAsString(msg);
                Optional.ofNullable(json).ifPresent(e -> STRING_REDIS_TEMPLATE.convertAndSend(channelName, e));
            }
            catch (JsonProcessingException e2) {
                e2.printStackTrace();
            }
        }
    }
}

