/*
 * Decompiled with CFR 0.152.
 */
package xin.altitude.cms.common.util;

import java.io.Serializable;
import java.util.Collection;
import java.util.Objects;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import xin.altitude.cms.common.util.RedisUtils;
import xin.altitude.cms.common.util.SpringUtils;

public class RedisBitMapUtils {
    private static final Logger logger = LoggerFactory.getLogger(RedisBitMapUtils.class);
    private static final StringRedisTemplate STRING_REDIS_TEMPLATE = SpringUtils.getBean(StringRedisTemplate.class);
    private static final ValueOperations<String, String> OPS_FOR_VALUE = STRING_REDIS_TEMPLATE.opsForValue();

    public static <T extends Serializable> void setBit(String key, T id) {
        RedisBitMapUtils.ifOffsetValid(Objects.hash(id), e -> OPS_FOR_VALUE.setBit((Object)key, (long)e.intValue(), true));
    }

    public static <T extends Serializable> void setBit(String key, Collection<T> ids) {
        ids.forEach(id -> RedisBitMapUtils.ifOffsetValid(Objects.hash(id), e -> OPS_FOR_VALUE.setBit((Object)key, (long)e.intValue(), true)));
    }

    public static <T extends Serializable> boolean getBit(String key, T id) {
        return RedisBitMapUtils.ifOffsetValid(Objects.hash(id), e -> OPS_FOR_VALUE.getBit((Object)key, (long)e.intValue()));
    }

    public static <T extends Serializable, R> R ifPresent(String key, T id, Function<T, R> action) {
        if (RedisBitMapUtils.getBit(key, id)) {
            return action.apply(id);
        }
        return null;
    }

    public static <T extends Serializable> void removeBit(String key, T id) {
        RedisBitMapUtils.ifOffsetValid(Objects.hash(id), e -> OPS_FOR_VALUE.setBit((Object)key, (long)e.intValue(), false));
    }

    public static <T extends Serializable> void removeBit(String key, Collection<T> ids) {
        ids.forEach(id -> RedisBitMapUtils.ifOffsetValid(Objects.hash(id), e -> OPS_FOR_VALUE.setBit((Object)key, (long)e.intValue(), false)));
    }

    public static <T extends Serializable> boolean checkId(String key, T id) {
        return RedisBitMapUtils.getBit(key, id);
    }

    public static void remove(String key) {
        RedisUtils.remove(key);
    }

    private static <N extends Number> Boolean ifOffsetValid(N offset, Function<N, Boolean> action) {
        Objects.requireNonNull(action);
        long max = 0xFFFFFFFFL;
        if (offset.intValue() >= 0 && offset.intValue() < Integer.MAX_VALUE) {
            return action.apply(offset);
        }
        if (offset.longValue() <= max) {
            return action.apply(offset);
        }
        logger.info(String.format("\u504f\u79fb\u91cf{%d}\u8d8a\u754c[0,%s]\uff0c\u672c\u6b21\u64cd\u4f5c\u4e0d\u6210\u529f\uff01", offset.longValue(), max));
        return false;
    }
}

