/*
 * Decompiled with CFR 0.152.
 */
package xin.altitude.cms.common.util;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.redis.core.StringRedisTemplate;
import org.springframework.data.redis.core.ValueOperations;
import xin.altitude.cms.common.util.BooleanUtils;
import xin.altitude.cms.common.util.EntityUtils;
import xin.altitude.cms.common.util.JacksonUtils;
import xin.altitude.cms.common.util.SpringUtils;

public class RedisAsyncUtils {
    private static final Logger logger = LoggerFactory.getLogger(RedisAsyncUtils.class);
    private static final StringRedisTemplate STRING_REDIS_TEMPLATE = SpringUtils.getBean(StringRedisTemplate.class);
    private static final ValueOperations<String, String> OPS_FOR_VALUE = STRING_REDIS_TEMPLATE.opsForValue();

    private static <T> byte[] toByte(T value) {
        Objects.requireNonNull(value);
        return JacksonUtils.writeValue(value).getBytes(StandardCharsets.UTF_8);
    }

    private static <T> T toObj(byte[] bytes, Class<T> clazz) {
        Objects.requireNonNull(bytes);
        return JacksonUtils.readObjectValue(new String(bytes), clazz);
    }

    public static <T> void save(String key, T value) {
        Objects.requireNonNull(key);
        Objects.requireNonNull(value);
        String jsonValue = JacksonUtils.writeValue(value);
        STRING_REDIS_TEMPLATE.execute(conn -> conn.set(RedisAsyncUtils.toByte(key), RedisAsyncUtils.toByte(jsonValue)));
    }

    public static <T> T getObject(String key, Class<T> clazz) {
        Objects.requireNonNull(key);
        return (T)STRING_REDIS_TEMPLATE.execute(conn -> RedisAsyncUtils.toObj(conn.get(RedisAsyncUtils.toByte(key)), clazz));
    }

    public static Boolean expire(Collection<String> keys, int sec) {
        STRING_REDIS_TEMPLATE.execute(conn -> {
            ArrayList<Boolean> bool = new ArrayList<Boolean>();
            keys.forEach(e -> bool.add(conn.expire(RedisAsyncUtils.toByte(e), (long)sec)));
            return BooleanUtils.isTrue(bool);
        });
        return false;
    }

    public static Boolean pExpire(Collection<String> keys, long millis) {
        STRING_REDIS_TEMPLATE.execute(conn -> {
            ArrayList<Boolean> bool = new ArrayList<Boolean>();
            keys.forEach(e -> bool.add(conn.pExpire(RedisAsyncUtils.toByte(e), millis)));
            return BooleanUtils.isTrue(bool);
        });
        return false;
    }

    public static Long remove(Collection<String> keys) {
        byte[][] bytes = EntityUtils.toArray(keys, RedisAsyncUtils::toByte);
        return Optional.ofNullable(bytes).map(e -> (Long)STRING_REDIS_TEMPLATE.execute(conn -> conn.del(e))).orElse(0L);
    }
}

