/*
 * Decompiled with CFR 0.152.
 */
package xin.altitude.cms.common.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import xin.altitude.cms.common.model.KVModel;
import xin.altitude.cms.common.util.ColUtils;
import xin.altitude.cms.common.util.EntityUtils;

public class MapUtils {
    private MapUtils() {
    }

    public static <K, V> boolean isEmpty(Map<K, V> map) {
        if (map == null) {
            return true;
        }
        return map.isEmpty();
    }

    public static <K, V> boolean isNotEmpty(Map<K, V> map) {
        return !MapUtils.isEmpty(map);
    }

    public static <K, V> void ifNotEmpty(Map<K, V> map, Consumer<Map<K, V>> consumer) {
        Objects.requireNonNull(consumer);
        if (MapUtils.isNotEmpty(map)) {
            consumer.accept(map);
        }
    }

    @SafeVarargs
    public static <K, V> List<V> getCollection(Map<K, V> map, K ... keys) {
        Objects.requireNonNull(keys);
        return MapUtils.getCollection(map, Arrays.asList(keys));
    }

    public static <K, V> List<V> getCollection(Map<K, V> map, Collection<K> keys) {
        Objects.requireNonNull(keys);
        ArrayList result = new ArrayList();
        MapUtils.ifNotEmpty(map, e -> keys.forEach(key -> Optional.ofNullable(e.get(key)).ifPresent(result::add)));
        return result;
    }

    public static <K, V> List<V> getCollection(Map<K, V> source, Collection<K> keys, Comparator<V> comparator) {
        List<V> result = MapUtils.getCollection(source, keys);
        Optional.ofNullable(comparator).ifPresent(result::sort);
        return result;
    }

    public static <K, V> List<KVModel<K, V>> mapToList(Map<K, V> source) {
        Objects.requireNonNull(source);
        List<KVModel<K, V>> result = source.entrySet().stream().map(e -> new KVModel(e.getKey(), e.getValue())).collect(Collectors.toList());
        return result;
    }

    public static <K, V, R> Map<K, R> transMap(Map<K, V> map, Function<? super V, ? extends R> valueAction) {
        Objects.requireNonNull(valueAction);
        HashMap hashMap = new HashMap(16);
        MapUtils.ifNotEmpty(map, e -> e.forEach((key, value) -> hashMap.put(key, EntityUtils.toObj(value, valueAction))));
        return hashMap;
    }

    public static <E extends Map.Entry<K, V>, K, V> Map<K, V> transMap(Collection<E> list) {
        return MapUtils.transMap(list, (E e) -> true);
    }

    public static <E extends Map.Entry<K, V>, K, V> Map<K, V> transMap(Collection<E> list, Predicate<E> pred) {
        Objects.requireNonNull(pred);
        if (ColUtils.isNotEmpty(list)) {
            HashMap map = new HashMap(16);
            list.stream().filter(pred).forEach(e -> map.put(e.getKey(), e.getValue()));
            return map;
        }
        return Collections.emptyMap();
    }

    public static <E, K, V> Map<K, V> transMap(Collection<E> list, Function<E, ? extends Map.Entry<K, V>> acton) {
        return MapUtils.transMap(EntityUtils.toList(list, acton));
    }

    public static <K, V> V getObj(Map<K, V> map, K key) {
        return Optional.ofNullable(map).map(e -> e.get(key)).orElse(null);
    }

    public static <K, V> V getObj(Map<K, V> map, K key, V defaultValue) {
        return (V)Optional.ofNullable(map).map(e -> e.get(key)).orElse(defaultValue);
    }

    public static <K, V, R> R getObj(Map<K, V> map, K key, Function<V, R> action) {
        Objects.requireNonNull(action);
        return Optional.ofNullable(map).map(e -> e.get(key)).map(action).orElse(null);
    }
}

