/*
 * Decompiled with CFR 0.152.
 */
package xin.altitude.cms.common.util;

import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.lang.invoke.SerializedLambda;
import java.lang.reflect.Method;
import java.util.Optional;

public class LambdaFieldUtils {
    public static <T> String getFieldName(SFunction<T, ?> column) {
        try {
            Method method = column.getClass().getDeclaredMethod("writeReplace", new Class[0]);
            method.setAccessible(Boolean.TRUE);
            SerializedLambda serializedLambda = (SerializedLambda)method.invoke(column, new Object[0]);
            String methodName = serializedLambda.getImplMethodName();
            return LambdaFieldUtils.resolveFieldName(methodName);
        }
        catch (ReflectiveOperationException e) {
            throw new RuntimeException(e);
        }
    }

    private static String resolveFieldName(String methodName) {
        if (methodName.startsWith("get")) {
            return LambdaFieldUtils.firstToLowerCase(methodName.substring(3));
        }
        if (methodName.startsWith("is")) {
            return LambdaFieldUtils.firstToLowerCase(methodName.substring(2));
        }
        return methodName;
    }

    private static String firstToLowerCase(String s) {
        return Optional.ofNullable(s).map(e -> e.substring(0, 1).toLowerCase() + e.substring(1)).orElse(null);
    }
}

