/*
 * Decompiled with CFR 0.152.
 */
package xin.altitude.cms.common.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.springframework.util.StringUtils;
import xin.altitude.cms.common.util.SpringUtils;

public class JacksonUtils {
    private static final ObjectMapper OBJECT_MAPPER = SpringUtils.getBean(ObjectMapper.class);

    public static String writeValue(Object obj) {
        return JacksonUtils.writeValueAsString(obj);
    }

    public static String writeValueAsString(Object obj) {
        try {
            return OBJECT_MAPPER.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static byte[] writeValueAsBytes(Object obj) {
        try {
            return OBJECT_MAPPER.writeValueAsBytes(obj);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static <T> T parse(String jsonValue, Class<T> clazz) {
        return JacksonUtils.readObjectValue(jsonValue, clazz);
    }

    public static <T> T readValue(String jsonValue, Class<T> clazz) {
        return JacksonUtils.readObjectValue(jsonValue, clazz);
    }

    public static <T> List<T> readValue(String jsonValue, Class<? extends List> collClazz, Class<T> elementClazz) {
        return JacksonUtils.readListValue(jsonValue, elementClazz);
    }

    public static <T> T readObjectValue(String jsonValue, Class<T> clazz) {
        return Optional.ofNullable(jsonValue).map(f -> {
            try {
                return OBJECT_MAPPER.readValue(f, clazz);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).orElse(null);
    }

    public static <T> T readObjectValue(byte[] bytes, Class<T> clazz) {
        return Optional.ofNullable(bytes).map(f -> {
            try {
                return OBJECT_MAPPER.readValue(f, clazz);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }).orElse(null);
    }

    public static <T> T readObjectValue(InputStream is, Class<T> clazz) {
        try {
            if (is.available() != 0) {
                return (T)OBJECT_MAPPER.readValue(is, clazz);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static <T> T readObjectValue(String jsonValue, JavaType javaType) {
        if (StringUtils.hasLength((String)jsonValue)) {
            try {
                return (T)OBJECT_MAPPER.readValue(jsonValue, javaType);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static <T> List<T> readListValue(String jsonValue, Class<T> elementClazz) {
        return (List)JacksonUtils.readObjectValue(jsonValue, JacksonUtils.getJavaType(List.class, elementClazz));
    }

    public static <T> JavaType getJavaType(Class<? extends Collection> collectionClazz, Class<T> elementClazz) {
        return OBJECT_MAPPER.getTypeFactory().constructCollectionType(List.class, elementClazz);
    }

    public static <T> List<T> readListValue(byte[] bytes, Class<T> elementClazz) {
        CollectionType javaType = OBJECT_MAPPER.getTypeFactory().constructCollectionType(List.class, elementClazz);
        if (javaType != null) {
            try {
                return (List)OBJECT_MAPPER.readValue(bytes, (JavaType)javaType);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        return null;
    }

    public static <T> List<T> readListValue(InputStream is, Class<T> elementClazz) {
        CollectionType javaType = OBJECT_MAPPER.getTypeFactory().constructCollectionType(List.class, elementClazz);
        try {
            if (is.available() != 0 && javaType != null) {
                return (List)OBJECT_MAPPER.readValue(is, (JavaType)javaType);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return null;
    }

    public static <T> T clone(T obj, Class<T> clazz) {
        return JacksonUtils.readObjectValue(JacksonUtils.writeValue(obj), clazz);
    }
}

