/*
 * Decompiled with CFR 0.152.
 */
package xin.altitude.cms.common.util;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.Wrappers;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.baomidou.mybatisplus.extension.service.IService;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import xin.altitude.cms.common.util.BeanCopyUtils;
import xin.altitude.cms.common.util.EntityUtils;
import xin.altitude.cms.common.util.RefUtils;
import xin.altitude.cms.common.util.SpringUtils;
import xin.altitude.cms.common.util.StringUtil;

public class FieldInjectUtils {
    private FieldInjectUtils() {
    }

    @SafeVarargs
    public static <V, S, R> void injectField(List<V> data, SFunction<V, R> fkColumn, Class<? extends IService<S>> clazz, SFunction<S, R> pkColumn, SFunction<V, ? extends Serializable> ... injectColumns) {
        IService<S> iService = SpringUtils.getBean(clazz);
        Set<R> ids = EntityUtils.toSet(data, fkColumn);
        if (ids.size() > 0 && injectColumns.length > 0) {
            String fieldName = RefUtils.getFiledName(fkColumn);
            List<String> injectFiledNames = RefUtils.getFiledNames(injectColumns);
            String[] selectField = new String[]{fieldName, String.join((CharSequence)",", injectFiledNames)};
            String selectStr = Arrays.stream(selectField).map(StringUtil::toUnderScoreCase).collect(Collectors.joining(","));
            QueryWrapper wrapper = (QueryWrapper)Wrappers.query(RefUtils.newInstance(iService.getEntityClass())).select(new String[]{selectStr}).in((Object)StringUtil.toUnderScoreCase(fieldName), ids);
            List list = iService.getBaseMapper().selectList((Wrapper)wrapper);
            Map<R, Object> map = EntityUtils.toMap(list, pkColumn, e -> e);
            FieldInjectUtils.doInjectField(data, fieldName, map, RefUtils.getFiledNames(injectColumns));
        }
    }

    public static <V, R, S, W> void injectListField(List<V> data, SFunction<V, R> pkColumn, Class<? extends IService<S>> clazz, SFunction<S, R> fkColumn, SFunction<V, W> injectColumn) {
        Set<R> deptIds = EntityUtils.toSet(data, pkColumn);
        if (deptIds.size() > 0) {
            IService<S> service = SpringUtils.getBean(clazz);
            LambdaQueryWrapper in = (LambdaQueryWrapper)Wrappers.lambdaQuery((Class)service.getEntityClass()).in(fkColumn, deptIds);
            List list = service.getBaseMapper().selectList((Wrapper)in);
            Map<R, List<S>> map = list.stream().collect(Collectors.groupingBy(fkColumn));
            String injectFiledName = RefUtils.getFiledName(injectColumn);
            String filedName = RefUtils.getFiledName(pkColumn);
            FieldInjectUtils.doInjectField(data, filedName, map, injectFiledName);
        }
    }

    @SafeVarargs
    public static <V, S, R> void injectField(List<V> mData, SFunction<V, R> fkColumn, List<S> vData, SFunction<S, R> pkColumn, SFunction<V, ? extends Serializable> ... injectColumns) {
        if (vData.size() > 0 && injectColumns.length > 0) {
            String fieldName = RefUtils.getFiledName(fkColumn);
            Map<R, Object> map = EntityUtils.toMap(vData, pkColumn, e -> e);
            FieldInjectUtils.doInjectField(mData, fieldName, map, RefUtils.getFiledNames(injectColumns));
        }
    }

    public static <V, S, R, W> void injectListField(List<V> vData, SFunction<V, R> pkColumn, List<S> mData, SFunction<S, R> fkColumn, SFunction<V, W> injectColumn) {
        if (mData.size() > 0 && injectColumn != null) {
            String fieldName = RefUtils.getFiledName(pkColumn);
            Map<R, List<S>> map = EntityUtils.groupBy(mData, fkColumn);
            FieldInjectUtils.doInjectField(vData, fieldName, map, RefUtils.getFiledName(injectColumn));
        }
    }

    @SafeVarargs
    public static <T, S, R> void injectField(IPage<T> page, SFunction<T, R> fkColumn, Class<? extends IService<S>> clazz, SFunction<S, R> pkColumn, SFunction<T, ? extends Serializable> ... injectColumns) {
        List records = page.getRecords();
        FieldInjectUtils.injectField(records, fkColumn, clazz, pkColumn, injectColumns);
    }

    public static <V, R, S, W> void injectListField(IPage<V> page, SFunction<V, R> pkColumn, Class<? extends IService<S>> clazz, SFunction<S, R> fkColumn, SFunction<V, W> injectColumn) {
        List records = page.getRecords();
        FieldInjectUtils.injectListField(records, pkColumn, clazz, fkColumn, injectColumn);
    }

    @SafeVarargs
    public static <T, S, R, W> void injectField2(List<T> data, SFunction<T, R> fkColumn, Class<? extends IService<S>> clazz, SFunction<S, R> pkColumn, SFunction<T, ? extends Serializable> ... injectColumns) {
        IService<S> iService = SpringUtils.getBean(clazz);
        Set<R> ids = EntityUtils.toSet(data, fkColumn);
        if (ids.size() > 0 && injectColumns.length > 0) {
            String fieldName = RefUtils.getFiledName(fkColumn);
            LambdaQueryWrapper wrapper = (LambdaQueryWrapper)Wrappers.lambdaQuery((Class)iService.getEntityClass()).in(pkColumn, ids);
            List list = iService.getBaseMapper().selectList((Wrapper)wrapper);
            Map<R, Object> map = EntityUtils.toMap(list, pkColumn, e -> e);
            FieldInjectUtils.doInjectField(data, fieldName, map, RefUtils.getFiledNames(injectColumns));
        }
    }

    private static <T, S, R> void doInjectField(List<T> data, String fieldName, Map<R, S> map, List<String> filedNames) {
        if (fieldName != null && filedNames.size() > 0) {
            for (T t : data) {
                Object r = RefUtils.getFieldValue(t, fieldName);
                S s = map.get(r);
                BeanCopyUtils.copyProperties(s, t, filedNames);
            }
        }
    }

    private static <V, S, R> void doInjectField(List<V> data, String pkFieldName, Map<R, List<S>> map, String injectFieldName) {
        if (pkFieldName != null && injectFieldName != null) {
            for (V v : data) {
                Object r = RefUtils.getFieldValue(v, pkFieldName);
                List<S> s = map.get(r);
                RefUtils.setFiledValue(v, injectFieldName, s);
            }
        }
    }

    private static <T, K extends Serializable, V extends Serializable> void doInjectField(T t, Map<K, V> map, String keyFieldName, String injectFieldName) {
        Serializable k = (Serializable)RefUtils.getFieldValue(t, keyFieldName);
        Serializable v = (Serializable)map.get(k);
        RefUtils.setFiledValue(t, injectFieldName, (Object)v);
    }

    public static <AR, K extends Serializable, V extends Serializable, VO> List<VO> injectField(List<VO> voData, Map<K, V> map, SFunction<AR, K> keyAction, SFunction<AR, V> valueAction) {
        return ArWrapper.injectField(voData, map, keyAction, valueAction);
    }

    public static <AR, K extends Serializable, V extends Serializable, VO> List<VO> injectField(List<VO> voData, List<AR> arData, SFunction<AR, K> keyAction, SFunction<AR, V> valueAction) {
        return ArWrapper.injectField(voData, arData, keyAction, valueAction);
    }

    public static <AR, K extends Serializable, V extends Serializable, S, VO> List<VO> injectField(List<S> sData, Class<VO> voClazz, List<AR> arData, SFunction<AR, K> keyAction, SFunction<AR, V> valueAction) {
        return ArWrapper.injectField(sData, voClazz, arData, keyAction, valueAction);
    }

    public static <AR, K extends Serializable, V extends Serializable, S, VO extends AR> List<VO> injectField(Class<? extends IService<S>> serviceClazz, Class<VO> voClazz, List<AR> arData, SFunction<AR, K> keyAction, SFunction<AR, V> valueAction) {
        return ArWrapper.injectField(serviceClazz, voClazz, arData, keyAction, valueAction);
    }

    private static class ArWrapper {
        private ArWrapper() {
        }

        public static <AR, K extends Serializable, V extends Serializable, VO> List<VO> injectField(List<VO> voData, Map<K, V> map, SFunction<AR, K> keyAction, SFunction<AR, V> valueAction) {
            ArrayList<VO> rs = new ArrayList<VO>();
            String keyFieldName = RefUtils.getFiledName(keyAction);
            String injectFieldName = RefUtils.getFiledName(valueAction);
            for (VO vo : voData) {
                ArWrapper.doInjectField(vo, map, keyFieldName, injectFieldName);
                rs.add(vo);
            }
            return rs;
        }

        public static <AR, K extends Serializable, V extends Serializable, VO> List<VO> injectField(List<VO> voData, List<AR> arData, SFunction<AR, K> keyAction, SFunction<AR, V> valueAction) {
            Map<K, V> map = EntityUtils.toMap(arData, keyAction, valueAction);
            return ArWrapper.injectField(voData, map, keyAction, valueAction);
        }

        public static <AR, K extends Serializable, V extends Serializable, S, VO> List<VO> injectField(List<S> sData, Class<VO> voClazz, List<AR> arData, SFunction<AR, K> keyAction, SFunction<AR, V> valueAction) {
            List<Object> voList = EntityUtils.toList(sData, e -> BeanCopyUtils.copyProperties(e, voClazz));
            return ArWrapper.injectField(voList, arData, keyAction, valueAction);
        }

        public static <AR, K extends Serializable, V extends Serializable, S, VO extends AR> List<VO> injectField(Class<? extends IService<S>> serviceClazz, Class<VO> voClazz, List<AR> arData, SFunction<AR, K> keyAction, SFunction<AR, V> valueAction) {
            Set<K> deptIds = EntityUtils.toSet(arData, keyAction);
            if (deptIds.size() > 0) {
                IService<S> service = SpringUtils.getBean(serviceClazz);
                List sData = service.getBaseMapper().selectBatchIds(deptIds);
                return ArWrapper.injectField(sData, voClazz, arData, keyAction, valueAction);
            }
            return null;
        }

        public static <T, K extends Serializable, V extends Serializable> void doInjectField(T t, Map<K, V> map, String keyFieldName, String injectFieldName) {
            Serializable k = (Serializable)RefUtils.getFieldValue(t, keyFieldName);
            Serializable v = (Serializable)map.get(k);
            RefUtils.setFiledValue(t, injectFieldName, (Object)v);
        }
    }
}

