/*
 * Decompiled with CFR 0.152.
 */
package xin.altitude.cms.common.util;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.io.Serializable;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import xin.altitude.cms.common.support.DefaultEntry;
import xin.altitude.cms.common.util.EntityUtils;
import xin.altitude.cms.common.util.MapUtils;
import xin.altitude.cms.common.util.RefUtils;

public class FieldFilterUtils {
    private FieldFilterUtils() {
    }

    @SafeVarargs
    public static <T> Map<?, ?> filterFields(T obj, SFunction<T, ? extends Serializable> ... columns) {
        return FieldFilterUtils.filterFields(obj, false, columns);
    }

    @SafeVarargs
    public static <T> Map<?, ?> filterFields(T obj, boolean isInclude, SFunction<T, ? extends Serializable> ... columns) {
        return Optional.of(obj).map(e -> {
            HashSet<String> fieldNames = new HashSet<String>(RefUtils.getFiledNames(columns));
            Map<String, Object> map = EntityUtils.toMap(obj);
            return FieldFilterUtils.doFilter(map, fieldNames, isInclude);
        }).orElse(null);
    }

    @SafeVarargs
    public static <T> List<? extends Map<?, ?>> filterFields(List<T> list, SFunction<T, ? extends Serializable> ... action) {
        return FieldFilterUtils.filterFields(list, false, action);
    }

    @SafeVarargs
    public static <T> List<? extends Map<?, ?>> filterFields(List<T> list, boolean isInclude, SFunction<T, ? extends Serializable> ... action) {
        return Optional.of(list).map(f -> EntityUtils.toList(f, e -> FieldFilterUtils.filterFields(e, isInclude, action))).orElse(null);
    }

    @SafeVarargs
    public static <T> IPage<? extends Map<?, ?>> filterFields(IPage<T> page, SFunction<T, ? extends Serializable> ... columns) {
        return FieldFilterUtils.filterFields(page, false, columns);
    }

    @SafeVarargs
    public static <T> IPage<? extends Map<?, ?>> filterFields(IPage<T> page, boolean isInclude, SFunction<T, ? extends Serializable> ... columns) {
        return Optional.of(page).map(f -> EntityUtils.toPage(f, e -> FieldFilterUtils.filterFields(e, isInclude, columns))).orElse(null);
    }

    private static Map<String, Object> doFilter(Map<String, Object> map, Set<String> fieldNames, boolean contains) {
        if (contains) {
            List<DefaultEntry> list = EntityUtils.toList(fieldNames, e -> new DefaultEntry((String)e, map.get(e)));
            return MapUtils.transMap(list);
        }
        return MapUtils.transMap(map.entrySet(), e -> !fieldNames.contains(e.getKey()));
    }
}

