/*
 * Decompiled with CFR 0.152.
 */
package xin.altitude.cms.common.util;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import xin.altitude.cms.common.util.ColUtils;
import xin.altitude.cms.common.util.RefUtils;

public class FieldCleanUtils {
    @SafeVarargs
    public static <T> void cleanFields(T obj, SFunction<T, ? extends Serializable> ... columns) {
        Objects.requireNonNull(obj);
        if (ColUtils.isNotEmpty(columns)) {
            HashSet<String> set = new HashSet<String>(RefUtils.getFiledNames(columns));
            List fieldList = ReflectionKit.getFieldList(obj.getClass());
            FieldCleanUtils.handleField(obj, fieldList, e -> set.contains(e.getName()));
        }
    }

    @SafeVarargs
    public static <T> void cleanFields(List<T> list, SFunction<T, ? extends Serializable> ... columns) {
        if (ColUtils.isNotEmpty(columns) && ColUtils.isNotEmpty(list)) {
            HashSet<String> set = new HashSet<String>(RefUtils.getFiledNames(columns));
            List fieldList = ReflectionKit.getFieldList(ColUtils.toObj(list).getClass());
            list.forEach(t -> FieldCleanUtils.handleField(t, fieldList, e -> set.contains(e.getName())));
        }
    }

    @SafeVarargs
    public static <T> void cleanFields(IPage<T> page, SFunction<T, ? extends Serializable> ... columns) {
        Optional.ofNullable(page).ifPresent(e -> FieldCleanUtils.cleanFields(e.getRecords(), columns));
    }

    @SafeVarargs
    public static <T> void retainFields(T obj, SFunction<T, ? extends Serializable> ... columns) {
        Objects.requireNonNull(obj);
        if (ColUtils.isNotEmpty(columns)) {
            HashSet<String> set = new HashSet<String>(RefUtils.getFiledNames(columns));
            List fieldList = ReflectionKit.getFieldList(obj.getClass());
            FieldCleanUtils.handleField(obj, fieldList, e -> !set.contains(e.getName()));
        }
    }

    @SafeVarargs
    public static <T> void retainFields(List<T> list, SFunction<T, ? extends Serializable> ... columns) {
        if (ColUtils.isNotEmpty(columns) && ColUtils.isNotEmpty(list)) {
            HashSet<String> set = new HashSet<String>(RefUtils.getFiledNames(columns));
            List fieldList = ReflectionKit.getFieldList(ColUtils.toObj(list).getClass());
            list.forEach(t -> FieldCleanUtils.handleField(t, fieldList, e -> !set.contains(e.getName())));
        }
    }

    @SafeVarargs
    public static <T> void retainFields(IPage<T> page, SFunction<T, ? extends Serializable> ... columns) {
        Optional.ofNullable(page).ifPresent(e -> FieldCleanUtils.retainFields(e.getRecords(), columns));
    }

    private static <T> void handleField(T t, List<Field> fieldList, Predicate<Field> predicate) {
        fieldList.stream().filter(predicate).forEach(e -> RefUtils.setFiledValue(t, e, null));
    }
}

