/*
 * Decompiled with CFR 0.152.
 */
package xin.altitude.cms.common.util;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import java.lang.reflect.Array;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.stream.Collector;
import java.util.stream.Collectors;
import xin.altitude.cms.common.support.ArrayCollector;
import xin.altitude.cms.common.util.ColUtils;
import xin.altitude.cms.common.util.RefUtils;

public class EntityUtils {
    private EntityUtils() {
    }

    public static <R, S, T, A> R collectCommon(Collection<S> source, Function<? super S, ? extends T> action, Collector<? super T, A, R> collector) {
        Objects.requireNonNull(source);
        Objects.requireNonNull(collector);
        return source.stream().map(action).collect(collector);
    }

    public static <T, R> R toObj(T obj, Function<? super T, ? extends R> action) {
        Objects.requireNonNull(action);
        return Optional.ofNullable(obj).map(action).orElse(null);
    }

    public static <T, R> List<R> toList(Collection<T> list, Function<? super T, ? extends R> action) {
        Objects.requireNonNull(action);
        if (Objects.nonNull(list)) {
            return list.stream().map(action).collect(Collectors.toList());
        }
        return new ArrayList();
    }

    public static <T, VO> List<VO> toList(Collection<T> list, Class<VO> voClazz) {
        if (list != null && list.size() > 0) {
            T obj = ColUtils.toObj(list);
            Constructor constructor = RefUtils.getConstructor(voClazz, obj.getClass());
            return EntityUtils.toList(list, (? super T e) -> RefUtils.newInstance(constructor, e));
        }
        return new ArrayList();
    }

    public static <T> T[] toArray(List<T> list) {
        if (ColUtils.isNotEmpty(list)) {
            Class<?> tClazz = Objects.requireNonNull(ColUtils.toObj(list)).getClass();
            ArrayCollector collector = new ArrayCollector(RefUtils.getClass(tClazz));
            return (Object[])list.stream().collect(collector);
        }
        return null;
    }

    public static <T, R> R[] toArray(Collection<T> list, Function<? super T, ? extends R> action) {
        Objects.requireNonNull(action);
        if (ColUtils.isNotEmpty(list)) {
            Class<?> rClazz = EntityUtils.toObj(ColUtils.toObj(list), action).getClass();
            ArrayCollector collector = new ArrayCollector(RefUtils.getClass(rClazz));
            return (Object[])list.stream().map(action).collect(collector);
        }
        return null;
    }

    public static <T, R> R[] toArray(Collection<T> list, Function<? super T, ? extends R> action, IntFunction<R[]> generator) {
        Objects.requireNonNull(action);
        if (ColUtils.isNotEmpty(list)) {
            return list.stream().map(action).toArray(generator);
        }
        return null;
    }

    public static <T, R> R[] toArray(Collection<T> list, Function<? super T, ? extends R> action, Class<R[]> clazz) {
        Objects.requireNonNull(action);
        Objects.requireNonNull(clazz);
        Class<Object> itemClazz = clazz.isArray() ? clazz.getComponentType() : clazz;
        IntFunction<R[]> generator = e -> (Object[])Array.newInstance(itemClazz, e);
        return EntityUtils.toArray(list, action, generator);
    }

    public static <E extends IPage<T>, T, R> IPage<R> toPage(E page, Function<? super T, ? extends R> action) {
        Objects.requireNonNull(page);
        Objects.requireNonNull(action);
        return page.convert(action);
    }

    public static <T> Map<String, Object> toMap(T obj) {
        Objects.requireNonNull(obj);
        List fieldList = ReflectionKit.getFieldList(obj.getClass());
        HashMap<String, Object> map = new HashMap<String, Object>();
        fieldList.forEach(e -> map.put(e.getName(), RefUtils.getFieldValue(obj, e)));
        return map;
    }

    public static <T> Map<String, Object> toMap(T obj, Predicate<Field> pred) {
        Objects.requireNonNull(obj);
        Objects.requireNonNull(pred);
        List<Field> fieldList = ReflectionKit.getFieldList(obj.getClass()).stream().filter(pred).collect(Collectors.toList());
        HashMap<String, Object> map = new HashMap<String, Object>();
        fieldList.forEach(e -> map.put(e.getName(), RefUtils.getFieldValue(obj, e)));
        return map;
    }

    public static <T, K> Map<K, T> toMap(Collection<T> list, Function<? super T, ? extends K> keyAction) {
        Objects.requireNonNull(keyAction);
        return EntityUtils.toMap(list, keyAction, Function.identity());
    }

    public static <T, K, V> Map<K, V> toMap(Collection<T> list, Function<? super T, ? extends K> keyAction, Function<? super T, ? extends V> valueAction) {
        Objects.requireNonNull(keyAction);
        Objects.requireNonNull(valueAction);
        if (ColUtils.isNotEmpty(list)) {
            return list.stream().collect(Collectors.toMap(keyAction, valueAction));
        }
        return Collections.emptyMap();
    }

    public static <T> Set<T> toSet(Collection<T> list) {
        if (ColUtils.isNotEmpty(list)) {
            return new HashSet<T>(list);
        }
        return Collections.emptySet();
    }

    public static <T, R> Set<R> toSet(Collection<T> data, Function<? super T, ? extends R> action) {
        Objects.requireNonNull(action);
        if (Objects.nonNull(data)) {
            return data.stream().map(action).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    public static <E, G> Map<G, List<E>> groupBy(Collection<E> list, Function<E, G> gColumn) {
        Objects.requireNonNull(gColumn);
        if (Objects.nonNull(list)) {
            return list.stream().collect(Collectors.groupingBy(gColumn));
        }
        return Collections.emptyMap();
    }

    public static <E, G, U> Map<G, List<U>> groupBy(Collection<E> list, Function<E, G> gColumn, Function<E, U> action) {
        Objects.requireNonNull(gColumn);
        if (Objects.nonNull(list)) {
            return list.stream().collect(Collectors.groupingBy(gColumn, Collectors.mapping(action, Collectors.toList())));
        }
        return Collections.emptyMap();
    }
}

