/*
 * Decompiled with CFR 0.152.
 */
package xin.altitude.cms.common.util;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.ToIntFunction;

public class ColUtils {
    private ColUtils() {
    }

    public static <E> boolean isEmpty(Collection<E> data) {
        if (data == null) {
            return true;
        }
        return data.size() == 0;
    }

    public static <E> boolean isEmpty(E[] data) {
        if (data == null) {
            return true;
        }
        return data.length == 0;
    }

    public static <E> boolean isNotEmpty(Collection<E> data) {
        return !ColUtils.isEmpty(data);
    }

    public static <E> void ifNotEmpty(Collection<E> coll, Consumer<Collection<E>> consumer) {
        Objects.requireNonNull(consumer);
        if (ColUtils.isNotEmpty(coll)) {
            consumer.accept(coll);
        }
    }

    public static <E, R> List<R> ifNotEmpty(Collection<E> coll, Function<E, R> action) {
        Objects.requireNonNull(action);
        if (ColUtils.isNotEmpty(coll)) {
            ArrayList rs = new ArrayList(coll.size());
            coll.forEach(e -> rs.add(action.apply(e)));
            return rs;
        }
        return Collections.emptyList();
    }

    public static <E> boolean isNotEmpty(E[] data) {
        return !ColUtils.isEmpty(data);
    }

    public static <E> void ifNotEmpty(E[] data, Consumer<E[]> consumer) {
        Objects.requireNonNull(consumer);
        if (ColUtils.isNotEmpty(data)) {
            consumer.accept(data);
        }
    }

    public static <E, R> List<R> ifNotEmpty(E[] data, Function<E, R> action) {
        Objects.requireNonNull(action);
        if (ColUtils.isNotEmpty(data)) {
            ArrayList<R> rs = new ArrayList<R>(data.length);
            for (E e : data) {
                rs.add(action.apply(e));
            }
            return rs;
        }
        return Collections.emptyList();
    }

    public static <E> List<E> toCol(E obj) {
        if (obj == null) {
            return Collections.emptyList();
        }
        return Collections.singletonList(obj);
    }

    public static <E> E toObj(Collection<E> coll) {
        if (ColUtils.isNotEmpty(coll)) {
            return coll.iterator().next();
        }
        return null;
    }

    public static <E> E max(Collection<E> data, ToIntFunction<? super E> column) {
        Objects.requireNonNull(column);
        if (ColUtils.isNotEmpty(data)) {
            return data.stream().max(Comparator.comparingInt(column)).orElse(null);
        }
        return null;
    }

    public static <E, U extends Comparable<? super U>> E max(Collection<E> data, Function<? super E, ? extends U> column) {
        Objects.requireNonNull(column);
        if (ColUtils.isNotEmpty(data)) {
            return data.stream().max(Comparator.comparing(column)).orElse(null);
        }
        return null;
    }

    public static <E> E max(Collection<E> data, Comparator<? super E> comparator) {
        Objects.requireNonNull(comparator);
        if (ColUtils.isNotEmpty(data)) {
            return data.stream().max(comparator).orElse(null);
        }
        return null;
    }

    public static <E> E min(Collection<E> data, ToIntFunction<? super E> column) {
        Objects.requireNonNull(column);
        if (ColUtils.isNotEmpty(data)) {
            return data.stream().min(Comparator.comparingInt(column)).orElse(null);
        }
        return null;
    }

    public static <E, U extends Comparable<? super U>> E min(Collection<E> data, Function<? super E, ? extends U> column) {
        Objects.requireNonNull(column);
        if (ColUtils.isNotEmpty(data)) {
            return data.stream().min(Comparator.comparing(column)).orElse(null);
        }
        return null;
    }

    public static <E> E min(Collection<E> data, Comparator<? super E> comparator) {
        Objects.requireNonNull(comparator);
        if (ColUtils.isNotEmpty(data)) {
            return data.stream().min(comparator).orElse(null);
        }
        return null;
    }
}

