/*
 * Decompiled with CFR 0.152.
 */
package xin.altitude.cms.common.util;

import com.baomidou.mybatisplus.core.toolkit.ReflectionKit;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;

public class BeanCopyUtils {
    private BeanCopyUtils() {
    }

    public static void copyProperties(Object source, Object target) {
        if (source != null && target != null) {
            List fieldList = ReflectionKit.getFieldList(target.getClass());
            HashSet set = new HashSet();
            try {
                for (Field field : fieldList) {
                    field.setAccessible(true);
                    Optional.ofNullable(field.get(target)).ifPresent(e -> set.add(field.getName()));
                }
            }
            catch (IllegalAccessException e2) {
                e2.printStackTrace();
            }
            String[] ignoreProperties = set.toArray(new String[0]);
            BeanUtils.copyProperties((Object)source, (Object)target, (String[])ignoreProperties);
        }
    }

    public static void copyProperties(Object source, Object target, String ... includeProperties) {
        if (source != null && target != null) {
            Set set = Arrays.stream(includeProperties).collect(Collectors.toSet());
            List fieldList = ReflectionKit.getFieldList(source.getClass());
            String[] ignoreProperties = (String[])fieldList.stream().map(Field::getName).filter(s -> !set.contains(s)).toArray(String[]::new);
            BeanUtils.copyProperties((Object)source, (Object)target, (String[])ignoreProperties);
        }
    }

    public static void copyProperties(Object source, Object target, List<String> includeProperties) {
        BeanCopyUtils.copyProperties(source, target, includeProperties.toArray(new String[0]));
    }

    public static <T> T copyProperties(Object source, Class<T> clazz) {
        try {
            T target = clazz.newInstance();
            BeanUtils.copyProperties((Object)source, target);
            return target;
        }
        catch (IllegalAccessException | InstantiationException e) {
            e.printStackTrace();
            return null;
        }
    }
}

