/*
 * Decompiled with CFR 0.152.
 */
package xin.altitude.cms.common.support;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BinaryOperator;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

public class ArrayCollector<R>
implements Collector<R, List<R>, R[]> {
    private static final Set<Collector.Characteristics> CHARACTERISTICS = Collections.emptySet();
    private final Class<R> elementType;

    public ArrayCollector(Class<R> elementType) {
        this.elementType = elementType;
    }

    @Override
    public BiConsumer<List<R>, R> accumulator() {
        return List::add;
    }

    @Override
    public Set<Collector.Characteristics> characteristics() {
        return CHARACTERISTICS;
    }

    @Override
    public BinaryOperator<List<R>> combiner() {
        return (left, right) -> {
            left.addAll(right);
            return left;
        };
    }

    @Override
    public Function<List<R>, R[]> finisher() {
        return list -> {
            Object[] array = (Object[])Array.newInstance(this.elementType, list.size());
            return list.toArray(array);
        };
    }

    @Override
    public Supplier<List<R>> supplier() {
        return ArrayList::new;
    }
}

