/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.component.text;

import java.awt.Color;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.util.Matrix;
import wiki.xsx.core.pdf.component.XEasyPdfComponent;
import wiki.xsx.core.pdf.component.XEasyPdfPagingCondition;
import wiki.xsx.core.pdf.component.text.XEasyPdfTextBase;
import wiki.xsx.core.pdf.component.text.XEasyPdfTextParam;
import wiki.xsx.core.pdf.component.text.XEasypdfTextRenderingMode;
import wiki.xsx.core.pdf.doc.XEasyPdfDefaultFontStyle;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.doc.XEasyPdfPage;
import wiki.xsx.core.pdf.doc.XEasyPdfPositionStyle;
import wiki.xsx.core.pdf.util.XEasyPdfTextUtil;

public class XEasyPdfText
extends XEasyPdfTextBase {
    private static final long serialVersionUID = -4199419015054023227L;
    private XEasyPdfTextParam param = new XEasyPdfTextParam();

    XEasyPdfText(XEasyPdfTextParam param) {
        this.param = param;
    }

    public XEasyPdfText(String text) {
        this.param.setText(text);
    }

    public XEasyPdfText(List<String> textList) {
        if (textList != null) {
            this.param.setSplitTextList(new ArrayList<String>(textList)).setSplitTemplateTextList(new ArrayList<String>(textList));
        }
    }

    public XEasyPdfText(float fontSize, String text) {
        this.param.setFontSize(Float.valueOf(Math.abs(fontSize))).setText(text);
    }

    public XEasyPdfText(float fontSize, List<String> textList) {
        this.param.setFontSize(Float.valueOf(Math.abs(fontSize)));
        if (textList != null) {
            this.param.setSplitTextList(new ArrayList<String>(textList)).setSplitTemplateTextList(new ArrayList<String>(textList));
        }
    }

    public XEasyPdfText enableTextAppend() {
        this.param.setIsTextAppend(Boolean.TRUE);
        return this;
    }

    public XEasyPdfText enableCenterStyle() {
        this.param.setHorizontalStyle(XEasyPdfPositionStyle.CENTER).setVerticalStyle(XEasyPdfPositionStyle.CENTER);
        return this;
    }

    public XEasyPdfText enableChildComponent() {
        this.param.setIsChildComponent(Boolean.TRUE);
        return this;
    }

    public XEasyPdfText enableUnderline() {
        this.param.setIsUnderline(Boolean.TRUE);
        return this;
    }

    public XEasyPdfText enableDeleteLine() {
        this.param.setIsDeleteLine(Boolean.TRUE);
        return this;
    }

    public XEasyPdfText enableHighlight() {
        this.param.setIsHighlight(Boolean.TRUE);
        return this;
    }

    public XEasyPdfText enableRotateLine() {
        this.param.setIsRotateLine(Boolean.TRUE);
        return this;
    }

    @Override
    public XEasyPdfText enableResetContext() {
        this.param.setIsResetContext(Boolean.TRUE);
        return this;
    }

    public XEasyPdfText enableSelfStyle() {
        this.param.setUseSelfStyle(Boolean.TRUE);
        return this;
    }

    public XEasyPdfText disableSelfStyle() {
        this.param.setUseSelfStyle(Boolean.FALSE);
        return this;
    }

    public XEasyPdfText setAutoIndent(int indent) {
        this.param.setIndent(Math.abs(indent));
        return this;
    }

    @Override
    void setBeginX(Float beginX) {
        this.param.setBeginX(beginX);
    }

    @Override
    void setBeginY(Float beginY) {
        this.param.setBeginY(beginY);
    }

    public XEasyPdfText setMargin(float margin) {
        this.param.setMarginLeft(Float.valueOf(margin)).setMarginRight(Float.valueOf(margin)).setMarginTop(Float.valueOf(margin)).setMarginBottom(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfText setMarginLeft(float margin) {
        this.param.setMarginLeft(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfText setMarginRight(float margin) {
        this.param.setMarginRight(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfText setMarginTop(float margin) {
        this.param.setMarginTop(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfText setMarginBottom(float margin) {
        this.param.setMarginBottom(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfText setLeading(float leading) {
        this.param.setLeading(Float.valueOf(Math.abs(leading)));
        return this;
    }

    public XEasyPdfText setCharacterSpacing(float characterSpacing) {
        this.param.setCharacterSpacing(Float.valueOf(Math.abs(characterSpacing)));
        return this;
    }

    public XEasyPdfText setFontPath(String fontPath) {
        this.param.setFontPath(fontPath);
        return this;
    }

    public XEasyPdfText setDefaultFontStyle(XEasyPdfDefaultFontStyle style) {
        if (style != null) {
            this.param.setFontPath(style.getPath());
        }
        return this;
    }

    public XEasyPdfText setFontSize(float fontSize) {
        this.param.setFontSize(Float.valueOf(Math.abs(fontSize)));
        return this;
    }

    public XEasyPdfText setFontColor(Color fontColor) {
        if (fontColor != null) {
            this.param.setFontColor(fontColor);
        }
        return this;
    }

    public XEasyPdfText setHighlightColor(Color highlightColor) {
        if (highlightColor != null) {
            this.param.setHighlightColor(highlightColor);
        }
        return this;
    }

    public XEasyPdfText setUnderlineColor(Color underlineColor) {
        if (underlineColor != null) {
            this.param.setUnderlineColor(underlineColor);
        }
        return this;
    }

    public XEasyPdfText setUnderlineWidth(float underlineWidth) {
        this.param.setUnderlineWidth(Float.valueOf(Math.abs(underlineWidth)));
        return this;
    }

    public XEasyPdfText setDeleteLineColor(Color deleteLineColor) {
        if (deleteLineColor != null) {
            this.param.setDeleteLineColor(deleteLineColor);
        }
        return this;
    }

    public XEasyPdfText setDeleteLineWidth(float deleteLineWidth) {
        this.param.setDeleteLineWidth(Float.valueOf(Math.abs(deleteLineWidth)));
        return this;
    }

    public XEasyPdfText setLink(String linkUrl) {
        this.param.setLinkUrl(linkUrl);
        return this;
    }

    public XEasyPdfText setComment(String comment) {
        this.param.setComment(comment);
        return this;
    }

    public XEasyPdfText setAlpha(float alpha) {
        if (alpha >= 0.0f && alpha <= 1.0f) {
            this.param.setAlpha(Float.valueOf(alpha));
        }
        return this;
    }

    public XEasyPdfText setRadians(double radians) {
        boolean min = false;
        int max = 360;
        if (radians % 360.0 != 0.0) {
            if ((radians %= 360.0) < 0.0) {
                radians += 360.0;
            }
            this.param.setRadians(radians);
        }
        return this;
    }

    public XEasyPdfText setHorizontalStyle(XEasyPdfPositionStyle style) {
        if (style != null) {
            XEasyPdfPositionStyle.checkHorizontalStyle(style);
            this.param.setHorizontalStyle(style);
        }
        return this;
    }

    public XEasyPdfText setVerticalStyle(XEasyPdfPositionStyle style) {
        if (style != null) {
            XEasyPdfPositionStyle.checkVerticalStyle(style);
            this.param.setVerticalStyle(style);
        }
        return this;
    }

    public XEasyPdfText setSplitTextList(List<String> splitTextList) {
        if (splitTextList == null) {
            this.param.setSplitTextList(null).setSplitTemplateTextList(null);
        } else {
            this.param.setSplitTextList(new ArrayList<String>(splitTextList)).setSplitTemplateTextList(new ArrayList<String>(splitTextList));
        }
        return this;
    }

    public XEasyPdfText setReplaceCharacters(String oldValue, String replacement) {
        if (oldValue != null && replacement != null) {
            this.param.getReplaceCharacterMap().put(oldValue, replacement);
        }
        return this;
    }

    public XEasyPdfText setReplaceCharacters(Map<String, String> replaceMap) {
        if (replaceMap != null && !replaceMap.isEmpty()) {
            this.param.getReplaceCharacterMap().putAll(replaceMap);
        }
        return this;
    }

    public XEasyPdfText setNewLine(boolean isNewLine) {
        this.param.setIsNewLine(isNewLine);
        return this;
    }

    public XEasyPdfText setCheckPage(boolean isCheckPage) {
        this.param.setCheckPage(isCheckPage);
        return this;
    }

    @Override
    public XEasyPdfText setPosition(float beginX, float beginY) {
        this.param.setBeginX(Float.valueOf(beginX)).setBeginY(Float.valueOf(beginY));
        return this;
    }

    @Override
    public XEasyPdfText setWidth(float width) {
        this.param.setMaxWidth(Float.valueOf(Math.abs(width)));
        return this;
    }

    @Override
    public XEasyPdfText setHeight(float height) {
        this.param.setMaxHeight(Float.valueOf(Math.abs(height)));
        return this;
    }

    public XEasyPdfText setMaxHeight(Float maxHeight) {
        this.param.setMaxHeight(maxHeight);
        return this;
    }

    @Override
    public XEasyPdfText setContentMode(XEasyPdfComponent.ContentMode mode) {
        if (mode != null) {
            this.param.setContentMode(mode);
        }
        return this;
    }

    public XEasyPdfText setRenderingMode(XEasypdfTextRenderingMode renderingMode) {
        if (renderingMode != null) {
            this.param.setRenderingMode(renderingMode);
        }
        return this;
    }

    @Override
    public XEasyPdfText setPagingCondition(XEasyPdfPagingCondition pagingCondition) {
        this.param.setPagingCondition(pagingCondition);
        return this;
    }

    @Override
    public XEasyPdfText setNeedInitialize(boolean needInitialize) {
        this.param.setIsNeedInitialize(needInitialize);
        return this;
    }

    public XEasyPdfText replaceAllPlaceholder(String placeholder, String value) {
        List<String> textList = this.param.getSplitTextList();
        List<String> templateTextList = this.param.getSplitTemplateTextList();
        int count = textList.size();
        for (int i = 0; i < count; ++i) {
            textList.set(i, templateTextList.get(i).replace(placeholder, value));
        }
        return this;
    }

    @Override
    public float getHeight(XEasyPdfDocument document, XEasyPdfPage page) {
        return this.param.getHeight(document, page);
    }

    @Override
    public float getWidth(XEasyPdfDocument document, XEasyPdfPage page) {
        return this.param.getWidth(document, page);
    }

    @Override
    public XEasyPdfComponent.ContentMode getContentMode() {
        return this.param.getContentMode();
    }

    @Override
    float getBeginY() {
        return this.param.getBeginY().floatValue();
    }

    @Override
    public float getMarginTop() {
        return this.param.getMarginTop().floatValue();
    }

    @Override
    public float getMarginBottom() {
        return this.param.getMarginBottom().floatValue();
    }

    @Override
    public float getMarginLeft() {
        return this.param.getMarginLeft().floatValue();
    }

    @Override
    public float getMarginRight() {
        return this.param.getMarginRight().floatValue();
    }

    @Override
    public List<String> getSplitTextList() {
        return this.param.getSplitTextList();
    }

    @Override
    public float getFontSize() {
        return this.param.getFontSize().floatValue();
    }

    @Override
    public String getFontPath() {
        return this.param.getFontPath();
    }

    @Override
    public float getLeading() {
        return this.param.getLeading().floatValue();
    }

    @Override
    public float getCharacterSpacing() {
        return this.param.getCharacterSpacing().floatValue();
    }

    @Override
    public float getAlpha() {
        return this.param.getAlpha().floatValue();
    }

    @Override
    Integer getIndent() {
        return this.param.getIndent();
    }

    @Override
    String getLinkUrl() {
        return this.param.getLinkUrl();
    }

    @Override
    String getComment() {
        return this.param.getComment();
    }

    @Override
    Color getFontColor() {
        return this.param.getFontColor();
    }

    @Override
    Color getHighlightColor() {
        return this.param.getHighlightColor();
    }

    @Override
    Color getUnderlineColor() {
        return this.param.getUnderlineColor();
    }

    @Override
    Color getDeleteLineColor() {
        return this.param.getDeleteLineColor();
    }

    @Override
    float getUnderlineWidth() {
        return this.param.getUnderlineWidth().floatValue();
    }

    @Override
    float getDeleteLineWidth() {
        return this.param.getDeleteLineWidth().floatValue();
    }

    public XEasyPdfPositionStyle getHorizontalStyle() {
        return this.param.getHorizontalStyle();
    }

    public XEasyPdfPositionStyle getVerticalStyle() {
        return this.param.getVerticalStyle();
    }

    @Override
    XEasypdfTextRenderingMode getRenderingMode() {
        return this.param.getRenderingMode();
    }

    @Override
    XEasyPdfPagingCondition getPagingCondition() {
        return this.param.getPagingCondition();
    }

    @Override
    boolean isUseSelfStyle() {
        return this.param.getUseSelfStyle();
    }

    @Override
    public boolean isNeedInitialize() {
        return this.param.getIsNeedInitialize();
    }

    @Override
    boolean isResetContext() {
        return this.param.getIsResetContext();
    }

    @Override
    boolean isNewLine() {
        return this.param.getIsNewLine();
    }

    @Override
    boolean isTextAppend() {
        return this.param.getIsTextAppend();
    }

    @Override
    boolean isHighlight() {
        return this.param.getIsHighlight();
    }

    @Override
    boolean isUnderline() {
        return this.param.getIsUnderline();
    }

    @Override
    boolean isDeleteLine() {
        return this.param.getIsDeleteLine();
    }

    @Override
    boolean isCheckPage() {
        return this.param.getCheckPage();
    }

    @Override
    void init(XEasyPdfDocument document, XEasyPdfPage page) {
        this.param.init(document, page);
    }

    @Override
    float initBeginX(XEasyPdfDocument document, XEasyPdfPage page, String text) {
        return this.param.initBeginX(document, page, text).floatValue();
    }

    @Override
    void addText(PDFont font, XEasyPdfPage page, PDPageContentStream stream, String text, float beginX, float beginY) {
        if (this.param.getRadians() > 0.0) {
            if (this.param.getIsRotateLine().booleanValue()) {
                stream.beginText();
                stream.setTextMatrix(Matrix.getRotateInstance((double)Math.toRadians(this.param.getRadians()), (float)beginX, (float)beginY));
                stream.showText(text);
                stream.endText();
            } else {
                char[] charArray;
                float x = beginX;
                for (char c : charArray = text.toCharArray()) {
                    String textTemp = String.valueOf(c);
                    stream.beginText();
                    stream.setTextMatrix(Matrix.getRotateInstance((double)Math.toRadians(this.param.getRadians()), (float)x, (float)beginY));
                    stream.showText(textTemp);
                    stream.endText();
                    x += XEasyPdfTextUtil.getTextRealWidth(textTemp, font, this.param.getFontSize().floatValue(), this.param.getCharacterSpacing().floatValue());
                }
            }
        } else {
            stream.beginText();
            this.setItalic(stream, beginX, beginY);
            stream.showText(text);
            stream.endText();
        }
        stream.setStrokingColor(page.getBackgroundColor());
        stream.setNonStrokingColor(page.getBackgroundColor());
    }

    @Override
    PDRectangle getRectangleForWrite(PDFont font, String text, float beginX, float beginY) {
        PDRectangle rectangle = new PDRectangle();
        rectangle.setLowerLeftX(beginX);
        rectangle.setLowerLeftY(beginY);
        rectangle.setUpperRightY(beginY + this.param.getFontHeight().floatValue());
        if (this.param.getRadians() > 0.0) {
            rectangle.setUpperRightX(beginX + this.param.getFontSize().floatValue() * (float)text.length());
        } else {
            rectangle.setUpperRightX(beginX + XEasyPdfTextUtil.getTextRealWidth(text, font, this.param.getFontSize().floatValue(), this.getCharacterSpacing()));
        }
        return rectangle;
    }

    private void setItalic(PDPageContentStream stream, float beginX, float beginY) {
        if (this.param.getRenderingMode().isItalic()) {
            stream.setTextMatrix(new Matrix(1.0f, 0.0f, 0.2f, 1.0f, beginX, beginY));
        } else {
            stream.newLineAtOffset(beginX, beginY);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XEasyPdfText)) {
            return false;
        }
        XEasyPdfText other = (XEasyPdfText)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        XEasyPdfTextParam this$param = this.param;
        XEasyPdfTextParam other$param = other.param;
        return !(this$param == null ? other$param != null : !((Object)this$param).equals(other$param));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof XEasyPdfText;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        XEasyPdfTextParam $param = this.param;
        result = result * 59 + ($param == null ? 43 : ((Object)$param).hashCode());
        return result;
    }
}

