/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.component.table;

import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import wiki.xsx.core.pdf.component.XEasyPdfComponent;
import wiki.xsx.core.pdf.component.table.XEasyPdfCellBorder;
import wiki.xsx.core.pdf.component.table.XEasyPdfRow;
import wiki.xsx.core.pdf.component.table.XEasyPdfTableParam;
import wiki.xsx.core.pdf.doc.XEasyPdfDefaultFontStyle;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.doc.XEasyPdfPage;
import wiki.xsx.core.pdf.doc.XEasyPdfPositionStyle;

public class XEasyPdfTable
implements XEasyPdfComponent {
    private static final long serialVersionUID = 4155761069922557517L;
    private final XEasyPdfTableParam param = new XEasyPdfTableParam();

    public XEasyPdfTable(XEasyPdfRow ... rows) {
        this.addRow(rows);
    }

    public XEasyPdfTable(List<XEasyPdfRow> rowList) {
        this.addRow(rowList);
    }

    public XEasyPdfTable setFontPath(String fontPath) {
        this.param.setFontPath(fontPath);
        return this;
    }

    public XEasyPdfTable setDefaultFontStyle(XEasyPdfDefaultFontStyle style) {
        if (style != null) {
            this.param.setFontPath(style.getPath());
        }
        return this;
    }

    public XEasyPdfTable setFontSize(float fontSize) {
        this.param.setFontSize(Float.valueOf(Math.abs(fontSize)));
        return this;
    }

    public XEasyPdfTable setFontColor(Color fontColor) {
        if (fontColor != null) {
            this.param.setFontColor(fontColor);
        }
        return this;
    }

    public XEasyPdfTable setBorderWidth(float borderWidth) {
        this.param.setBorderWidth(Float.valueOf(Math.abs(borderWidth)));
        return this;
    }

    public XEasyPdfTable setBorderColor(Color borderColor) {
        if (borderColor != null) {
            this.param.setBorderColor(borderColor);
        }
        return this;
    }

    public XEasyPdfTable setBorderLineLength(float borderLineLength) {
        this.param.setBorderLineLength(Float.valueOf(Math.abs(borderLineLength)));
        return this;
    }

    public XEasyPdfTable setBorderLineSpace(float borderLineSpace) {
        this.param.setBorderLineSpace(Float.valueOf(Math.abs(borderLineSpace)));
        return this;
    }

    public XEasyPdfTable setBackgroundColor(Color backgroundColor) {
        if (backgroundColor != null) {
            this.param.setBackgroundColor(backgroundColor);
        }
        return this;
    }

    public XEasyPdfTable setMarginLeft(float margin) {
        this.param.setMarginLeft(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfTable setMarginTop(float margin) {
        this.param.setMarginTop(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfTable setMarginBottom(float margin) {
        this.param.setMarginBottom(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfTable setHorizontalStyle(XEasyPdfPositionStyle style) {
        if (style != null) {
            if (style == XEasyPdfPositionStyle.LEFT || style == XEasyPdfPositionStyle.CENTER || style == XEasyPdfPositionStyle.RIGHT) {
                this.param.setHorizontalStyle(style);
            } else {
                throw new IllegalArgumentException("only set LEFT, CENTER or RIGHT style");
            }
        }
        return this;
    }

    public XEasyPdfTable setVerticalStyle(XEasyPdfPositionStyle style) {
        if (style != null) {
            if (style == XEasyPdfPositionStyle.TOP || style == XEasyPdfPositionStyle.CENTER || style == XEasyPdfPositionStyle.BOTTOM) {
                this.param.setVerticalStyle(style);
            } else {
                throw new IllegalArgumentException("only set TOP, CENTER or BOTTOM style");
            }
        }
        return this;
    }

    public XEasyPdfTable enableCenterStyle() {
        this.param.setHorizontalStyle(XEasyPdfPositionStyle.CENTER).setVerticalStyle(XEasyPdfPositionStyle.CENTER);
        return this;
    }

    public XEasyPdfTable disableAutoSplitRow() {
        this.param.setIsAutoSplit(Boolean.FALSE);
        return this;
    }

    public XEasyPdfTable disableBorder() {
        this.param.setHasBorder(Boolean.FALSE);
        return this;
    }

    @Override
    public XEasyPdfTable enableResetContext() {
        this.param.setIsResetContext(Boolean.TRUE);
        return this;
    }

    public XEasyPdfTable enableAutoScaleFontSize() {
        this.param.setIsAutoScaleFontSize(Boolean.TRUE);
        return this;
    }

    @Override
    public XEasyPdfTable setPosition(float beginX, float beginY) {
        this.param.setBeginX(Float.valueOf(beginX)).setBeginY(Float.valueOf(beginY));
        return this;
    }

    @Override
    @Deprecated
    public XEasyPdfTable setWidth(float width) {
        return this;
    }

    @Override
    @Deprecated
    public XEasyPdfTable setHeight(float height) {
        return this;
    }

    @Override
    public XEasyPdfTable setContentMode(XEasyPdfComponent.ContentMode mode) {
        if (mode != null) {
            this.param.setContentMode(mode);
        }
        return this;
    }

    public XEasyPdfTable setMinRowHeight(float height) {
        this.param.setMinRowHeight(Float.valueOf(Math.abs(height)));
        return this;
    }

    public XEasyPdfTable setTitle(XEasyPdfTable title) {
        this.param.setTitle(title);
        return this;
    }

    public final XEasyPdfTable addRow(XEasyPdfRow ... rows) {
        if (rows != null) {
            this.addRow(Arrays.asList(rows));
        }
        return this;
    }

    public final XEasyPdfTable addRow(List<XEasyPdfRow> rowList) {
        if (rowList != null) {
            this.param.getRows().addAll(rowList);
        }
        return this;
    }

    public XEasyPdfTable insertRow(int rowIndex, XEasyPdfRow row) {
        if (row != null) {
            this.param.getRows().add(rowIndex, row);
        }
        return this;
    }

    @Override
    public void draw(XEasyPdfDocument document, XEasyPdfPage page) {
        page.disablePosition();
        this.param.init(document, page);
        if (this.param.getBeginX() != null) {
            page.setPageX(this.param.getBeginX());
        }
        if (this.param.getBeginY() != null) {
            page.setPageY(Float.valueOf(this.param.getBeginY().floatValue() - this.param.getMarginTop().floatValue()));
        } else {
            page.setPageY(Float.valueOf(page.getPageY() == null ? page.getLastPage().getMediaBox().getHeight() - this.param.getMarginTop().floatValue() : page.getPageY().floatValue() - this.param.getMarginTop().floatValue()));
        }
        XEasyPdfTable title = this.param.getTitle();
        if (title != null) {
            title.init(this.param);
            title.draw(document, page);
        }
        List<XEasyPdfRow> rows = this.param.getRows();
        for (XEasyPdfRow row : rows) {
            row.doDraw(document, page, this);
        }
        List<XEasyPdfCellBorder> cellBorderList = this.param.getCellBorderList();
        if (!cellBorderList.isEmpty()) {
            for (XEasyPdfCellBorder cellBorder : cellBorderList) {
                cellBorder.drawBorder();
            }
            cellBorderList.clear();
        }
        page.enablePosition();
    }

    XEasyPdfTableParam getParam() {
        return this.param;
    }

    void init(XEasyPdfTableParam param) {
        this.param.init(param);
    }
}

