/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.component.table;

import java.awt.Color;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import wiki.xsx.core.pdf.component.XEasyPdfComponent;
import wiki.xsx.core.pdf.component.table.XEasyPdfCell;
import wiki.xsx.core.pdf.component.table.XEasyPdfRowParam;
import wiki.xsx.core.pdf.component.table.XEasyPdfTable;
import wiki.xsx.core.pdf.doc.XEasyPdfDefaultFontStyle;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.doc.XEasyPdfPage;
import wiki.xsx.core.pdf.doc.XEasyPdfPositionStyle;

public class XEasyPdfRow
implements Serializable {
    private static final long serialVersionUID = 2954489044413380387L;
    private final XEasyPdfRowParam param = new XEasyPdfRowParam();

    public XEasyPdfRow(XEasyPdfCell ... cells) {
        if (cells != null) {
            Collections.addAll(this.param.getCells(), cells);
        }
    }

    public XEasyPdfRow(List<XEasyPdfCell> cellList) {
        if (cellList != null) {
            this.param.getCells().addAll(cellList);
        }
    }

    public XEasyPdfRow setContentMode(XEasyPdfComponent.ContentMode mode) {
        if (mode != null) {
            this.param.setContentMode(mode);
        }
        return this;
    }

    public XEasyPdfRow setFontPath(String fontPath) {
        this.param.setFontPath(fontPath);
        return this;
    }

    public XEasyPdfRow setDefaultFontStyle(XEasyPdfDefaultFontStyle style) {
        if (style != null) {
            this.param.setFontPath(style.getPath());
        }
        return this;
    }

    public XEasyPdfRow setFontSize(float fontSize) {
        this.param.setFontSize(Float.valueOf(Math.abs(fontSize)));
        return this;
    }

    public XEasyPdfRow setFontColor(Color fontColor) {
        if (fontColor != null) {
            this.param.setFontColor(fontColor);
        }
        return this;
    }

    public XEasyPdfRow setBackgroundColor(Color backgroundColor) {
        if (backgroundColor != null) {
            this.param.setBackgroundColor(backgroundColor);
        }
        return this;
    }

    public XEasyPdfRow setBorderWidth(float borderWidth) {
        this.param.setBorderWidth(Float.valueOf(Math.abs(borderWidth)));
        return this;
    }

    public XEasyPdfRow setBorderColor(Color borderColor) {
        if (borderColor != null) {
            this.param.setBorderColor(borderColor);
        }
        return this;
    }

    public XEasyPdfRow setBorderLineLength(float borderLineLength) {
        this.param.setBorderLineLength(Float.valueOf(Math.abs(borderLineLength)));
        return this;
    }

    public XEasyPdfRow setBorderLineSpace(float borderLineSpace) {
        this.param.setBorderLineSpace(Float.valueOf(Math.abs(borderLineSpace)));
        return this;
    }

    public XEasyPdfRow setHeight(float height) {
        this.param.setHeight(Float.valueOf(Math.abs(height)));
        return this;
    }

    public XEasyPdfRow setMinHeight(float minHeight) {
        this.param.setMinHeight(Float.valueOf(Math.abs(minHeight)));
        return this;
    }

    public XEasyPdfRow setMarginLeft(float margin) {
        this.param.setMarginLeft(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfRow setMarginTop(float margin) {
        this.param.setMarginTop(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfRow setHorizontalStyle(XEasyPdfPositionStyle style) {
        if (style != null) {
            if (style == XEasyPdfPositionStyle.LEFT || style == XEasyPdfPositionStyle.CENTER || style == XEasyPdfPositionStyle.RIGHT) {
                this.param.setHorizontalStyle(style);
            } else {
                throw new IllegalArgumentException("only set LEFT, CENTER or RIGHT style");
            }
        }
        return this;
    }

    public XEasyPdfRow setVerticalStyle(XEasyPdfPositionStyle style) {
        if (style != null) {
            if (style == XEasyPdfPositionStyle.TOP || style == XEasyPdfPositionStyle.CENTER || style == XEasyPdfPositionStyle.BOTTOM) {
                this.param.setVerticalStyle(style);
            } else {
                throw new IllegalArgumentException("only set TOP, CENTER or BOTTOM style");
            }
        }
        return this;
    }

    public XEasyPdfRow setBorderPolicy(BorderPolicy policy) {
        this.param.setBorderPolicy(policy);
        return this;
    }

    public XEasyPdfRow enableCenterStyle() {
        this.param.setHorizontalStyle(XEasyPdfPositionStyle.CENTER).setVerticalStyle(XEasyPdfPositionStyle.CENTER);
        return this;
    }

    public XEasyPdfRow enableBorder() {
        this.param.setHasBorder(Boolean.TRUE);
        return this;
    }

    public XEasyPdfRow disableBorder() {
        this.param.setHasBorder(Boolean.FALSE);
        return this;
    }

    public XEasyPdfRow enablePaging() {
        this.param.setIsPaging(Boolean.TRUE);
        return this;
    }

    public XEasyPdfRow enableResetContext() {
        this.param.setIsResetContext(Boolean.TRUE);
        return this;
    }

    public XEasyPdfRow enableAutoScaleFontSize() {
        this.param.setIsAutoScaleFontSize(Boolean.TRUE);
        return this;
    }

    public XEasyPdfRow addCell(XEasyPdfCell ... cells) {
        if (cells != null) {
            Collections.addAll(this.param.getCells(), cells);
        }
        return this;
    }

    public XEasyPdfRow addCell(List<XEasyPdfCell> cellList) {
        if (cellList != null) {
            this.param.getCells().addAll(cellList);
        }
        return this;
    }

    XEasyPdfRowParam getParam() {
        return this.param;
    }

    void doDraw(XEasyPdfDocument document, XEasyPdfPage page, XEasyPdfTable table) {
        this.param.init(document, page, table, this);
        List<XEasyPdfCell> cells = this.param.getCells();
        for (XEasyPdfCell cell : cells) {
            if (cell == null) continue;
            if (cell.getParam().getIsVerticalMerge().booleanValue()) {
                this.param.setBeginX(Float.valueOf(this.param.getBeginX().floatValue() + cell.getParam().getWidth().floatValue() + cell.getParam().getMarginLeft().floatValue()));
                continue;
            }
            this.param.setBeginX(Float.valueOf(this.param.getBeginX().floatValue() + cell.getParam().getMarginLeft().floatValue()));
            cell.doDraw(document, page, table, this);
            this.param.setBeginX(Float.valueOf(this.param.getBeginX().floatValue() + cell.getParam().getWidth().floatValue()));
        }
        this.param.setBeginX(null);
        page.setPageY(Float.valueOf(this.param.getBeginY().floatValue() - this.param.getHeight().floatValue()));
        XEasyPdfRow splitRow = this.param.getSplitRow();
        if (splitRow != null) {
            splitRow.doDraw(document, page, table);
        }
    }

    public static enum BorderPolicy {
        ONLY_LEFT_RIGHT,
        ONLY_TOP_BOTTOM,
        ONLY_TOP_LEFT_RIGHT,
        ONLY_BOTTOM_LEFT_RIGHT,
        ONLY_TOP,
        ONLY_BOTTOM,
        NONE;

    }
}

