/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.component.line;

import java.awt.Color;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import wiki.xsx.core.pdf.component.XEasyPdfComponent;
import wiki.xsx.core.pdf.component.line.XEasyPdfBaseLine;
import wiki.xsx.core.pdf.component.line.XEasyPdfLine;
import wiki.xsx.core.pdf.component.line.XEasyPdfLineCapStyle;
import wiki.xsx.core.pdf.component.line.XEasyPdfLineParam;
import wiki.xsx.core.pdf.doc.XEasyPdfDefaultFontStyle;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.doc.XEasyPdfPage;

public class XEasyPdfSolidSplitLine
implements XEasyPdfLine {
    private static final long serialVersionUID = 923483874195529438L;
    private final XEasyPdfLineParam param = new XEasyPdfLineParam();

    @Override
    public XEasyPdfSolidSplitLine setFontPath(String fontPath) {
        this.param.setFontPath(fontPath);
        return this;
    }

    @Override
    public XEasyPdfSolidSplitLine setDefaultFontStyle(XEasyPdfDefaultFontStyle style) {
        if (style != null) {
            this.param.setFontPath(style.getPath());
        }
        return this;
    }

    public XEasyPdfSolidSplitLine setMargin(float margin) {
        this.param.setMarginLeft(Float.valueOf(margin)).setMarginRight(Float.valueOf(margin)).setMarginTop(Float.valueOf(margin)).setMarginBottom(Float.valueOf(margin));
        return this;
    }

    @Override
    public XEasyPdfSolidSplitLine setMarginLeft(float margin) {
        this.param.setMarginLeft(Float.valueOf(margin));
        return this;
    }

    @Override
    public XEasyPdfSolidSplitLine setMarginRight(float margin) {
        this.param.setMarginRight(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfSolidSplitLine setMarginTop(float margin) {
        this.param.setMarginTop(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfSolidSplitLine setMarginBottom(float margin) {
        this.param.setMarginBottom(Float.valueOf(margin));
        return this;
    }

    @Override
    public XEasyPdfSolidSplitLine setLineWidth(float lineWidth) {
        this.param.setLineWidth(Float.valueOf(Math.abs(lineWidth)));
        return this;
    }

    @Override
    public XEasyPdfSolidSplitLine setColor(Color color) {
        if (color != null) {
            this.param.setColor(color);
        }
        return this;
    }

    @Override
    public XEasyPdfSolidSplitLine setLineCapStyle(XEasyPdfLineCapStyle lineCapStyle) {
        if (lineCapStyle != null) {
            this.param.setStyle(lineCapStyle);
        }
        return this;
    }

    @Override
    public XEasyPdfSolidSplitLine setPosition(float beginX, float beginY) {
        this.param.setBeginX(Float.valueOf(beginX)).setBeginY(Float.valueOf(beginY));
        return this;
    }

    @Override
    public XEasyPdfSolidSplitLine setWidth(float width) {
        this.param.setWidth(Float.valueOf(Math.abs(width)));
        return this;
    }

    @Override
    public XEasyPdfSolidSplitLine setHeight(float height) {
        return this;
    }

    @Override
    public XEasyPdfSolidSplitLine setContentMode(XEasyPdfComponent.ContentMode mode) {
        if (mode != null) {
            this.param.setContentMode(mode);
        }
        return this;
    }

    @Override
    public float getLineWidth() {
        return this.param.getLineWidth().floatValue();
    }

    @Override
    public XEasyPdfSolidSplitLine enableResetContext() {
        this.param.setIsResetContext(Boolean.TRUE);
        return this;
    }

    @Override
    public void draw(XEasyPdfDocument document, XEasyPdfPage page) {
        this.init(document, page);
        new XEasyPdfBaseLine(this.param).draw(document, page);
        if (page.isAllowResetPosition()) {
            page.setPageY(Float.valueOf(this.param.getBeginY().floatValue() - this.param.getLineWidth().floatValue() / 2.0f));
        }
    }

    private void init(XEasyPdfDocument document, XEasyPdfPage page) {
        this.param.checkPage(document, page);
        this.param.init(document, page);
        PDRectangle rectangle = page.getLastPage().getMediaBox();
        if (this.param.getBeginX() != null && this.param.getBeginY() != null) {
            if (this.param.getWidth() != null) {
                this.param.setEndX(Float.valueOf(this.param.getBeginX().floatValue() + this.param.getWidth().floatValue()));
            } else {
                this.param.setEndX(Float.valueOf(rectangle.getWidth() - this.param.getMarginRight().floatValue()));
            }
            this.param.setEndY(this.param.getBeginY());
            return;
        }
        float lineWidth = this.param.getLineWidth().floatValue() / 2.0f;
        this.param.setBeginX(this.param.getMarginLeft()).setBeginY(Float.valueOf(page.getPageY() == null ? rectangle.getHeight() - this.param.getMarginTop().floatValue() - lineWidth : page.getPageY().floatValue() - this.param.getMarginTop().floatValue() - lineWidth)).setEndX(Float.valueOf(rectangle.getWidth() - this.param.getMarginRight().floatValue())).setEndY(this.param.getBeginY());
    }
}

