/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.component.line;

import java.awt.Color;
import wiki.xsx.core.pdf.component.XEasyPdfComponent;
import wiki.xsx.core.pdf.component.line.XEasyPdfBaseLine;
import wiki.xsx.core.pdf.component.line.XEasyPdfLine;
import wiki.xsx.core.pdf.component.line.XEasyPdfLineCapStyle;
import wiki.xsx.core.pdf.component.line.XEasyPdfLineParam;
import wiki.xsx.core.pdf.doc.XEasyPdfDefaultFontStyle;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.doc.XEasyPdfPage;

public class XEasyPdfDottedSplitLine
implements XEasyPdfLine {
    private static final long serialVersionUID = -8849448173029414111L;
    private final XEasyPdfLineParam param = new XEasyPdfLineParam();
    private Float lineLength = Float.valueOf(10.0f);
    private Float lineSpace = Float.valueOf(10.0f);

    @Override
    public XEasyPdfDottedSplitLine setFontPath(String fontPath) {
        this.param.setFontPath(fontPath);
        return this;
    }

    @Override
    public XEasyPdfDottedSplitLine setDefaultFontStyle(XEasyPdfDefaultFontStyle style) {
        if (style != null) {
            this.param.setFontPath(style.getPath());
        }
        return this;
    }

    public XEasyPdfDottedSplitLine setMargin(float margin) {
        this.param.setMarginLeft(Float.valueOf(margin)).setMarginRight(Float.valueOf(margin)).setMarginTop(Float.valueOf(margin)).setMarginBottom(Float.valueOf(margin));
        return this;
    }

    @Override
    public XEasyPdfDottedSplitLine setMarginLeft(float margin) {
        this.param.setMarginLeft(Float.valueOf(margin));
        return this;
    }

    @Override
    public XEasyPdfDottedSplitLine setMarginRight(float margin) {
        this.param.setMarginRight(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfDottedSplitLine setMarginTop(float margin) {
        this.param.setMarginTop(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfDottedSplitLine setMarginBottom(float margin) {
        this.param.setMarginBottom(Float.valueOf(margin));
        return this;
    }

    @Override
    public XEasyPdfDottedSplitLine setLineWidth(float lineWidth) {
        this.param.setLineWidth(Float.valueOf(Math.abs(lineWidth)));
        return this;
    }

    @Override
    public XEasyPdfDottedSplitLine setColor(Color color) {
        if (color != null) {
            this.param.setColor(color);
        }
        return this;
    }

    @Override
    public XEasyPdfDottedSplitLine setLineCapStyle(XEasyPdfLineCapStyle lineCapStyle) {
        if (lineCapStyle != null) {
            this.param.setStyle(lineCapStyle);
        }
        return this;
    }

    public XEasyPdfDottedSplitLine setLineLength(float lineLength) {
        this.lineLength = Float.valueOf(Math.abs(lineLength));
        return this;
    }

    public XEasyPdfDottedSplitLine setLineSpace(float lineSpace) {
        this.lineSpace = Float.valueOf(Math.abs(lineSpace));
        return this;
    }

    @Override
    public XEasyPdfDottedSplitLine setPosition(float beginX, float beginY) {
        this.param.setBeginX(Float.valueOf(beginX)).setBeginY(Float.valueOf(beginY));
        return this;
    }

    @Override
    public XEasyPdfDottedSplitLine setWidth(float width) {
        this.param.setWidth(Float.valueOf(Math.abs(width)));
        return this;
    }

    @Override
    public XEasyPdfDottedSplitLine setHeight(float height) {
        return this;
    }

    @Override
    public XEasyPdfDottedSplitLine setContentMode(XEasyPdfComponent.ContentMode mode) {
        if (mode != null) {
            this.param.setContentMode(mode);
        }
        return this;
    }

    @Override
    public float getLineWidth() {
        return this.param.getLineWidth().floatValue();
    }

    @Override
    public XEasyPdfDottedSplitLine enableResetContext() {
        this.param.setIsResetContext(Boolean.TRUE);
        return this;
    }

    @Override
    public void draw(XEasyPdfDocument document, XEasyPdfPage page) {
        this.init(document, page);
        XEasyPdfBaseLine xpdfLine = new XEasyPdfBaseLine(this.param);
        xpdfLine.draw(document, page);
        int count = this.param.getWidth() == null ? (int)Math.floor((page.getLastPage().getMediaBox().getWidth() - this.param.getMarginLeft().floatValue() - this.param.getMarginRight().floatValue()) / (this.lineLength.floatValue() + this.lineSpace.floatValue())) : (int)Math.floor((this.param.getWidth().floatValue() - this.param.getMarginLeft().floatValue() - this.param.getMarginRight().floatValue()) / (this.lineLength.floatValue() + this.lineSpace.floatValue()));
        for (int j = 1; j <= count; ++j) {
            this.param.setBeginX(Float.valueOf(this.param.getEndX().floatValue() + this.lineSpace.floatValue())).setEndX(Float.valueOf(this.param.getBeginX().floatValue() + this.lineLength.floatValue()));
            xpdfLine = new XEasyPdfBaseLine(this.param);
            xpdfLine.draw(document, page);
        }
        if (page.isAllowResetPosition()) {
            page.setPageY(Float.valueOf(this.param.getBeginY().floatValue() - this.param.getLineWidth().floatValue() / 2.0f));
        }
        this.param.setBeginX(null).setBeginY(null);
    }

    private void init(XEasyPdfDocument document, XEasyPdfPage page) {
        this.param.checkPage(document, page);
        this.param.init(document, page);
        if (this.param.getBeginX() != null && this.param.getBeginY() != null) {
            this.param.setEndX(Float.valueOf(this.param.getBeginX().floatValue() + this.lineLength.floatValue())).setEndY(this.param.getBeginY());
            return;
        }
        float lineWidth = this.param.getLineWidth().floatValue() / 2.0f;
        this.param.setBeginX(this.param.getMarginLeft()).setBeginY(Float.valueOf(page.getPageY() == null ? page.getLastPage().getMediaBox().getHeight() - this.param.getMarginTop().floatValue() - lineWidth : page.getPageY().floatValue() - this.param.getMarginTop().floatValue() - lineWidth)).setEndX(Float.valueOf(this.param.getBeginX().floatValue() + this.lineLength.floatValue())).setEndY(this.param.getBeginY());
    }
}

