/*
 * Decompiled with CFR 0.152.
 */
package wiki.xsx.core.pdf.component.image;

import java.awt.image.BufferedImage;
import java.io.File;
import java.io.InputStream;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.graphics.image.PDImageXObject;
import wiki.xsx.core.pdf.component.XEasyPdfComponent;
import wiki.xsx.core.pdf.component.image.XEasyPdfImageParam;
import wiki.xsx.core.pdf.component.image.XEasyPdfImageType;
import wiki.xsx.core.pdf.doc.XEasyPdfDocument;
import wiki.xsx.core.pdf.doc.XEasyPdfPage;
import wiki.xsx.core.pdf.doc.XEasyPdfPositionStyle;
import wiki.xsx.core.pdf.util.XEasyPdfImageUtil;

public class XEasyPdfImage
implements XEasyPdfComponent {
    private static final long serialVersionUID = -5646605850827547633L;
    private final XEasyPdfImageParam param = new XEasyPdfImageParam();

    XEasyPdfImage() {
    }

    public XEasyPdfImage(File imageFile) {
        this.param.setImageType(XEasyPdfImageUtil.parseType(imageFile)).setImage(XEasyPdfImageUtil.read(imageFile));
    }

    public XEasyPdfImage(InputStream imageStream, XEasyPdfImageType imageType) {
        this.param.setImageType(imageType.name().toLowerCase()).setImage(XEasyPdfImageUtil.read(imageStream));
    }

    public XEasyPdfImage(BufferedImage image, XEasyPdfImageType imageType) {
        this.param.setImageType(imageType.name().toLowerCase()).setImage(image);
    }

    public XEasyPdfImage(File imageFile, int width, int height) {
        this.param.setImageType(XEasyPdfImageUtil.parseType(imageFile)).setImage(XEasyPdfImageUtil.read(imageFile)).setWidth(Math.abs(width)).setHeight(Math.abs(height)).setIsCustomRectangle(Boolean.TRUE);
    }

    public XEasyPdfImage(InputStream imageStream, XEasyPdfImageType imageType, int width, int height) {
        this.param.setImageType(imageType.name().toLowerCase()).setImage(XEasyPdfImageUtil.read(imageStream)).setWidth(Math.abs(width)).setHeight(Math.abs(height)).setIsCustomRectangle(Boolean.TRUE);
    }

    public XEasyPdfImage(BufferedImage image, XEasyPdfImageType imageType, int width, int height) {
        this.param.setImageType(imageType.name().toLowerCase()).setImage(image).setWidth(Math.abs(width)).setHeight(Math.abs(height)).setIsCustomRectangle(Boolean.TRUE);
    }

    public XEasyPdfImage setImage(File imageFile) {
        this.param.setImageType(XEasyPdfImageUtil.parseType(imageFile)).setImage(XEasyPdfImageUtil.read(imageFile));
        this.param.setImageXObject(null);
        return this;
    }

    public XEasyPdfImage setImage(BufferedImage image, XEasyPdfImageType imageType) {
        this.param.setImageType(imageType.name().toLowerCase()).setImage(image);
        this.param.setImageXObject(null);
        return this;
    }

    public XEasyPdfImage setImage(InputStream imageStream, XEasyPdfImageType imageType) {
        this.param.setImageType(imageType.name().toLowerCase()).setImage(XEasyPdfImageUtil.read(imageStream));
        this.param.setImageXObject(null);
        return this;
    }

    public XEasyPdfImage disableSelfAdaption() {
        this.param.setEnableSelfAdaption(Boolean.FALSE);
        return this;
    }

    public XEasyPdfImage enableSelfStyle() {
        this.param.setUseSelfStyle(Boolean.TRUE);
        return this;
    }

    public XEasyPdfImage enableCenterStyle() {
        this.param.setHorizontalStyle(XEasyPdfPositionStyle.CENTER).setVerticalStyle(XEasyPdfPositionStyle.CENTER);
        return this;
    }

    public XEasyPdfImage enableChildComponent() {
        this.param.setIsChildComponent(Boolean.TRUE);
        return this;
    }

    @Override
    public XEasyPdfImage enableResetContext() {
        this.param.setIsResetContext(Boolean.TRUE);
        return this;
    }

    public XEasyPdfImage setNeedInitialize(boolean needInitialize) {
        this.param.setIsNeedInitialize(needInitialize);
        return this;
    }

    public XEasyPdfImage setRadians(double radians) {
        if ((radians %= 360.0) != 0.0) {
            if (radians < 0.0) {
                radians += 360.0;
            }
            this.param.setRadians(radians);
        }
        return this;
    }

    public XEasyPdfImage setMaxWidth(float maxWidth) {
        this.param.setMaxWidth(Float.valueOf(Math.abs(maxWidth)));
        return this;
    }

    public XEasyPdfImage setMaxHeight(float maxHeight) {
        this.param.setMaxHeight(Float.valueOf(Math.abs(maxHeight)));
        return this;
    }

    public XEasyPdfImage setMargin(float margin) {
        this.param.setMarginLeft(Float.valueOf(margin)).setMarginRight(Float.valueOf(margin)).setMarginTop(Float.valueOf(margin)).setMarginBottom(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfImage setMarginLeft(float margin) {
        this.param.setMarginLeft(Float.valueOf(margin)).setHorizontalStyle(XEasyPdfPositionStyle.LEFT);
        return this;
    }

    public XEasyPdfImage setMarginRight(float margin) {
        this.param.setMarginRight(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfImage setMarginTop(float margin) {
        this.param.setMarginTop(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfImage setMarginBottom(float margin) {
        this.param.setMarginBottom(Float.valueOf(margin));
        return this;
    }

    public XEasyPdfImage setHorizontalStyle(XEasyPdfPositionStyle style) {
        if (style != null) {
            XEasyPdfPositionStyle.checkHorizontalStyle(style);
            this.param.setHorizontalStyle(style);
        }
        return this;
    }

    public XEasyPdfImage setVerticalStyle(XEasyPdfPositionStyle style) {
        if (style != null) {
            XEasyPdfPositionStyle.checkVerticalStyle(style);
            this.param.setVerticalStyle(style);
        }
        return this;
    }

    @Override
    public XEasyPdfImage setPosition(float beginX, float beginY) {
        this.param.setBeginX(Float.valueOf(beginX)).setBeginY(Float.valueOf(beginY));
        return this;
    }

    @Override
    public XEasyPdfImage setWidth(float width) {
        this.param.setWidth((int)Math.abs(width)).setIsCustomRectangle(Boolean.TRUE);
        return this;
    }

    @Override
    public XEasyPdfImage setHeight(float height) {
        this.param.setHeight((int)Math.abs(height)).setIsCustomRectangle(Boolean.TRUE);
        return this;
    }

    @Override
    public XEasyPdfImage setContentMode(XEasyPdfComponent.ContentMode mode) {
        if (mode != null) {
            this.param.setContentMode(mode);
        }
        return this;
    }

    @Override
    public void draw(XEasyPdfDocument document, XEasyPdfPage page) {
        PDImageXObject pdImage = this.param.init(document, page, this);
        this.param.initPosition(document, page);
        PDPageContentStream contentStream = new PDPageContentStream(document.getTarget(), page.getLastPage(), this.param.getContentMode().getMode(), true, this.param.getIsResetContext().booleanValue());
        contentStream.drawImage(pdImage, this.param.getBeginX().floatValue(), this.param.getBeginY().floatValue(), (float)this.param.getWidth().intValue(), (float)this.param.getHeight().intValue());
        contentStream.close();
        if (page.isAllowResetPosition()) {
            page.setPageX(this.param.getBeginX()).setPageY(this.param.getBeginY());
        }
        this.param.setBeginX(Float.valueOf(0.0f)).setBeginY(null);
        if (this.param.getImage() != null) {
            this.param.setImage(null);
        }
    }

    public XEasyPdfComponent.ContentMode getContentMode() {
        return this.param.getContentMode();
    }

    public Integer getWidth(XEasyPdfDocument document, XEasyPdfPage page) {
        if (this.param.getWidth() != null) {
            return this.param.getWidth();
        }
        this.param.init(document, page, this);
        return this.param.getWidth();
    }

    public Integer getHeight(XEasyPdfDocument document, XEasyPdfPage page) {
        if (this.param.getHeight() != null) {
            return this.param.getHeight();
        }
        this.param.init(document, page, this);
        return this.param.getHeight();
    }

    public float getMarginTop() {
        return this.param.getMarginTop().floatValue();
    }

    public float getMarginBottom() {
        return this.param.getMarginBottom().floatValue();
    }

    public float getMarginLeft() {
        return this.param.getMarginLeft().floatValue();
    }

    public float getMarginRight() {
        return this.param.getMarginRight().floatValue();
    }

    public XEasyPdfPositionStyle getHorizontalStyle() {
        return this.param.getHorizontalStyle();
    }

    public XEasyPdfPositionStyle getVerticalStyle() {
        return this.param.getVerticalStyle();
    }

    public boolean isUseSelfStyle() {
        return this.param.getUseSelfStyle();
    }

    public boolean isCustomRectangle() {
        return this.param.getIsCustomRectangle();
    }

    public boolean isNeedInitialize() {
        return this.param.getIsNeedInitialize();
    }

    XEasyPdfImageParam getParam() {
        return this.param;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof XEasyPdfImage)) {
            return false;
        }
        XEasyPdfImage other = (XEasyPdfImage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        XEasyPdfImageParam this$param = this.getParam();
        XEasyPdfImageParam other$param = other.getParam();
        return !(this$param == null ? other$param != null : !((Object)this$param).equals(other$param));
    }

    protected boolean canEqual(Object other) {
        return other instanceof XEasyPdfImage;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        XEasyPdfImageParam $param = this.getParam();
        result = result * 59 + ($param == null ? 43 : ((Object)$param).hashCode());
        return result;
    }
}

