/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.naming.consistency.persistent.impl;

import com.alibaba.nacos.core.exception.ErrorCode;
import com.alibaba.nacos.core.exception.KvStorageException;
import com.alibaba.nacos.core.storage.StorageFactory;
import com.alibaba.nacos.core.storage.kv.KvStorage;
import com.alibaba.nacos.core.storage.kv.MemoryKvStorage;
import com.alibaba.nacos.naming.misc.Loggers;
import com.alibaba.nacos.sys.utils.TimerContext;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;

public class NamingKvStorage
extends MemoryKvStorage {
    private static final String LOAD_SNAPSHOT = NamingKvStorage.class.getSimpleName() + ".snapshotLoad";
    private static final String LABEL = "naming-persistent";
    private final String baseDir;
    private final KvStorage baseDirStorage;

    public NamingKvStorage(String baseDir) throws Exception {
        this.baseDir = baseDir;
        this.baseDirStorage = StorageFactory.createKvStorage((KvStorage.KvType)KvStorage.KvType.File, (String)LABEL, (String)baseDir);
    }

    public byte[] get(byte[] key) throws KvStorageException {
        byte[] result = super.get(key);
        if (null == result) {
            try {
                KvStorage storage = this.getStorage();
                byte[] byArray = result = null == storage ? null : storage.get(key);
                if (null != result) {
                    super.put(key, result);
                }
            }
            catch (Exception e) {
                throw new KvStorageException(ErrorCode.KVStorageWriteError.getCode(), "Get data failed, key: " + new String(key) + ", detail: " + e.getMessage(), (Throwable)e);
            }
        }
        return result;
    }

    public Map<byte[], byte[]> batchGet(List<byte[]> keys) throws KvStorageException {
        HashMap<byte[], byte[]> result = new HashMap<byte[], byte[]>(keys.size());
        for (byte[] key : keys) {
            byte[] val = this.get(key);
            if (val == null) continue;
            result.put(key, val);
        }
        return result;
    }

    public void put(byte[] key, byte[] value) throws KvStorageException {
        try {
            KvStorage storage = this.getStorage();
            storage.put(key, value);
        }
        catch (Exception e) {
            throw new KvStorageException(ErrorCode.KVStorageWriteError.getCode(), "Put data failed, key: " + new String(key) + ", detail: " + e.getMessage(), (Throwable)e);
        }
        super.put(key, value);
    }

    public void batchPut(List<byte[]> keys, List<byte[]> values) throws KvStorageException {
        if (keys.size() != values.size()) {
            throw new KvStorageException(ErrorCode.KVStorageBatchWriteError, "key's size must be equal to value's size");
        }
        int size = keys.size();
        for (int i = 0; i < size; ++i) {
            this.put(keys.get(i), values.get(i));
        }
    }

    public void delete(byte[] key) throws KvStorageException {
        try {
            KvStorage storage = this.getStorage();
            if (null != storage) {
                storage.delete(key);
            }
        }
        catch (Exception e) {
            throw new KvStorageException(ErrorCode.KVStorageDeleteError.getCode(), "Delete data failed, key: " + new String(key) + ", detail: " + e.getMessage(), (Throwable)e);
        }
        super.delete(key);
    }

    public void batchDelete(List<byte[]> keys) throws KvStorageException {
        for (byte[] each : keys) {
            this.delete(each);
        }
    }

    public void doSnapshot(String backupPath) throws KvStorageException {
        this.baseDirStorage.doSnapshot(backupPath);
    }

    public void snapshotLoad(String path) throws KvStorageException {
        TimerContext.start((String)LOAD_SNAPSHOT);
        try {
            this.baseDirStorage.snapshotLoad(path);
            this.loadSnapshotFromActualStorage(this.baseDirStorage);
        }
        finally {
            TimerContext.end((String)LOAD_SNAPSHOT, (Logger)Loggers.RAFT);
        }
    }

    private void loadSnapshotFromActualStorage(KvStorage actualStorage) throws KvStorageException {
        for (byte[] each : actualStorage.allKeys()) {
            byte[] datum = actualStorage.get(each);
            super.put(each, datum);
        }
    }

    public List<byte[]> allKeys() throws KvStorageException {
        return super.allKeys();
    }

    public void shutdown() {
        this.baseDirStorage.shutdown();
        super.shutdown();
    }

    private KvStorage getStorage() throws Exception {
        return this.baseDirStorage;
    }
}

