/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.plugin.datasource.proxy;

import com.alibaba.nacos.common.utils.JacksonUtils;
import com.alibaba.nacos.plugin.datasource.mapper.Mapper;
import com.alibaba.nacos.plugin.datasource.model.MapperResult;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapperProxy
implements InvocationHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapperProxy.class);
    private Mapper mapper;
    private static final Map<String, Mapper> SINGLE_MAPPER_PROXY_MAP = new ConcurrentHashMap<String, Mapper>(16);

    public <R> R createProxy(Mapper mapper) {
        this.mapper = mapper;
        return (R)Proxy.newProxyInstance(MapperProxy.class.getClassLoader(), mapper.getClass().getInterfaces(), (InvocationHandler)this);
    }

    public static <R> R createSingleProxy(Mapper mapper) {
        return (R)SINGLE_MAPPER_PROXY_MAP.computeIfAbsent(mapper.getClass().getSimpleName(), key -> (Mapper)new MapperProxy().createProxy(mapper));
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        Object invoke = method.invoke((Object)this.mapper, args);
        String className = this.mapper.getClass().getSimpleName();
        String methodName = method.getName();
        String sql = invoke instanceof MapperResult ? ((MapperResult)invoke).getSql() : invoke.toString();
        LOGGER.info("[{}] METHOD : {}, SQL : {}, ARGS : {}", new Object[]{className, methodName, sql, JacksonUtils.toJson((Object)args)});
        return invoke;
    }
}

