/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.remote.grpc.negotiator;

import com.alibaba.nacos.common.spi.NacosServiceLoader;
import com.alibaba.nacos.core.remote.grpc.negotiator.NacosGrpcProtocolNegotiator;
import com.alibaba.nacos.core.remote.grpc.negotiator.ProtocolNegotiatorBuilder;
import com.alibaba.nacos.core.remote.grpc.negotiator.tls.DefaultTlsProtocolNegotiatorBuilder;
import com.alibaba.nacos.core.utils.Loggers;
import com.alibaba.nacos.sys.env.EnvUtil;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class ProtocolNegotiatorBuilderSingleton
implements ProtocolNegotiatorBuilder {
    private static final String TYPE_PROPERTY_KEY = "nacos.remote.server.rpc.protocol.negotiator.type";
    private static final ProtocolNegotiatorBuilderSingleton SINGLETON = new ProtocolNegotiatorBuilderSingleton();
    private final Map<String, ProtocolNegotiatorBuilder> builderMap;
    private String actualType = EnvUtil.getProperty((String)"nacos.remote.server.rpc.protocol.negotiator.type", (String)"DEFAULT_TLS");

    private ProtocolNegotiatorBuilderSingleton() {
        this.builderMap = new ConcurrentHashMap<String, ProtocolNegotiatorBuilder>();
        this.loadAllBuilders();
    }

    private void loadAllBuilders() {
        try {
            for (ProtocolNegotiatorBuilder each : NacosServiceLoader.load(ProtocolNegotiatorBuilder.class)) {
                this.builderMap.put(each.type(), each);
                Loggers.REMOTE.info("Load ProtocolNegotiatorBuilder {} for type {}", (Object)each.getClass().getCanonicalName(), (Object)each.type());
            }
        }
        catch (Exception e) {
            Loggers.REMOTE.warn("Load ProtocolNegotiatorBuilder failed, use default ProtocolNegotiatorBuilder", (Throwable)e);
            this.builderMap.put("DEFAULT_TLS", new DefaultTlsProtocolNegotiatorBuilder());
            this.actualType = "DEFAULT_TLS";
        }
    }

    public static ProtocolNegotiatorBuilderSingleton getSingleton() {
        return SINGLETON;
    }

    @Override
    public NacosGrpcProtocolNegotiator build() {
        ProtocolNegotiatorBuilder actualBuilder = this.builderMap.get(this.actualType);
        if (null == actualBuilder) {
            Loggers.REMOTE.warn("Not found ProtocolNegotiatorBuilder for type {}, will use default", (Object)this.actualType);
            return this.builderMap.get("DEFAULT_TLS").build();
        }
        return actualBuilder.build();
    }

    @Override
    public String type() {
        return this.actualType;
    }
}

