/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.control;

import com.alibaba.nacos.common.utils.StringUtils;
import com.alibaba.nacos.plugin.control.configs.ControlConfigs;
import com.alibaba.nacos.plugin.control.configs.ControlConfigsInitializer;
import com.alibaba.nacos.sys.env.EnvUtil;

public class SpringValueConfigsInitializer
implements ControlConfigsInitializer {
    private static final String PREFIX = "nacos.plugin.control.";
    private static final String CONNECTION_RUNTIME_EJECTOR = "nacos.plugin.control.connection.runtime.ejector";
    private static final String CONTROL_MANAGER_TYPE = "nacos.plugin.control.manager.type";
    private static final String RULE_EXTERNAL_STORAGE = "nacos.plugin.control.rule.external.storage";
    private static final String LOCAL_RULE_STORAGE_BASE_DIR = "nacos.plugin.control.rule.local.basedir";
    private static final String DEFAULT_CONNECTION_RUNTIME_EJECTOR = "nacos";

    public void initialize(ControlConfigs controlConfigs) {
        controlConfigs.setConnectionRuntimeEjector(EnvUtil.getProperty((String)CONNECTION_RUNTIME_EJECTOR, (String)DEFAULT_CONNECTION_RUNTIME_EJECTOR));
        String localRuleStorageBaseDir = EnvUtil.getProperty((String)LOCAL_RULE_STORAGE_BASE_DIR);
        if (StringUtils.isNotBlank((String)localRuleStorageBaseDir)) {
            controlConfigs.setLocalRuleStorageBaseDir(localRuleStorageBaseDir);
        } else {
            controlConfigs.setLocalRuleStorageBaseDir(EnvUtil.getNacosHome());
        }
        controlConfigs.setRuleExternalStorage(EnvUtil.getProperty((String)RULE_EXTERNAL_STORAGE));
        controlConfigs.setControlManagerType(EnvUtil.getProperty((String)CONTROL_MANAGER_TYPE));
    }
}

