/*
 * Decompiled with CFR 0.152.
 */
package com.alibaba.nacos.core.config;

import com.alibaba.nacos.common.utils.ConvertUtils;
import com.alibaba.nacos.sys.env.EnvUtil;
import com.alibaba.nacos.sys.module.ModuleState;
import com.alibaba.nacos.sys.module.ModuleStateBuilder;

public class RaftModuleStateBuilder
implements ModuleStateBuilder {
    public static final String SPLICE_CHARACTER = "nacos.core.protocol.raft.";

    public ModuleState build() {
        ModuleState moduleState = new ModuleState("raft");
        moduleState.newState("election_timeout_ms", (Object)Math.max(RaftModuleStateBuilder.stringToInt("election_timeout_ms", 5000), 5000));
        moduleState.newState("snapshot_interval_secs", (Object)RaftModuleStateBuilder.stringToInt("snapshot_interval_secs", 1800));
        moduleState.newState("core_thread_num", (Object)RaftModuleStateBuilder.stringToInt("core_thread_num", 8));
        moduleState.newState("cli_service_thread_num", (Object)RaftModuleStateBuilder.stringToInt("cli_service_thread_num", 4));
        moduleState.newState("read_index_type", (Object)RaftModuleStateBuilder.getProperty("read_index_type"));
        moduleState.newState("read_index_type", (Object)RaftModuleStateBuilder.getProperty("read_index_type"));
        moduleState.newState("rpc_request_timeout_ms", (Object)RaftModuleStateBuilder.stringToInt("rpc_request_timeout_ms", 5000));
        moduleState.newState("max_byte_count_per_rpc", (Object)RaftModuleStateBuilder.stringToInt("max_byte_count_per_rpc", 131072));
        moduleState.newState("max_entries_size", (Object)RaftModuleStateBuilder.stringToInt("max_entries_size", 1024));
        moduleState.newState("max_body_size", (Object)RaftModuleStateBuilder.stringToInt("max_body_size", 524288));
        moduleState.newState("max_append_buffer_size", (Object)RaftModuleStateBuilder.stringToInt("max_append_buffer_size", 262144));
        moduleState.newState("max_election_delay_ms", (Object)RaftModuleStateBuilder.stringToInt("max_election_delay_ms", 1000));
        moduleState.newState("election_heartbeat_factor", (Object)RaftModuleStateBuilder.stringToInt("election_heartbeat_factor", 10));
        moduleState.newState("apply_batch", (Object)RaftModuleStateBuilder.stringToInt("apply_batch", 32));
        moduleState.newState("sync", (Object)RaftModuleStateBuilder.stringToBoolean("sync", true));
        moduleState.newState("sync_meta", (Object)RaftModuleStateBuilder.stringToBoolean("sync_meta", false));
        moduleState.newState("disruptor_buffer_size", (Object)RaftModuleStateBuilder.stringToInt("disruptor_buffer_size", 16384));
        moduleState.newState("replicator_pipeline", (Object)RaftModuleStateBuilder.stringToBoolean("replicator_pipeline", true));
        moduleState.newState("max_replicator_inflight_msgs", (Object)RaftModuleStateBuilder.stringToInt("max_replicator_inflight_msgs", 256));
        moduleState.newState("enable_log_entry_checksum", (Object)RaftModuleStateBuilder.stringToBoolean("enable_log_entry_checksum", false));
        return moduleState;
    }

    public static int stringToInt(String key, int defaultValue) {
        return ConvertUtils.toInt((String)RaftModuleStateBuilder.getProperty(key), (int)defaultValue);
    }

    public static boolean stringToBoolean(String key, boolean defaultValue) {
        return ConvertUtils.toBoolean((String)RaftModuleStateBuilder.getProperty(key), (boolean)defaultValue);
    }

    public static String getProperty(String key) {
        return EnvUtil.getProperty((String)(SPLICE_CHARACTER + key));
    }

    public boolean isIgnore() {
        return EnvUtil.getStandaloneMode();
    }
}

