/*
 * Decompiled with CFR 0.152.
 */
package oracle.toplink.essentials.platform.database;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Hashtable;
import java.util.Vector;
import oracle.toplink.essentials.exceptions.ValidationException;
import oracle.toplink.essentials.expressions.ExpressionOperator;
import oracle.toplink.essentials.internal.databaseaccess.FieldTypeDefinition;
import oracle.toplink.essentials.internal.expressions.ParameterExpression;
import oracle.toplink.essentials.internal.helper.BasicTypeHelperImpl;
import oracle.toplink.essentials.internal.helper.ClassConstants;
import oracle.toplink.essentials.internal.helper.DatabaseTable;
import oracle.toplink.essentials.internal.helper.Helper;
import oracle.toplink.essentials.internal.helper.JavaPlatform;
import oracle.toplink.essentials.internal.sessions.AbstractSession;
import oracle.toplink.essentials.platform.database.DatabasePlatform;
import oracle.toplink.essentials.queryframework.SQLCall;
import oracle.toplink.essentials.queryframework.ValueReadQuery;

public class DB2Platform
extends DatabasePlatform {
    protected void appendByteArray(byte[] bytes, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("BLOB(x'");
            Helper.writeHexString(bytes, writer);
            writer.write("')");
        } else {
            super.appendByteArray(bytes, writer);
        }
    }

    protected void appendDate(Date date, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            this.appendDB2Date(date, writer);
        } else {
            super.appendDate(date, writer);
        }
    }

    protected void appendDB2Date(Date date, Writer writer) throws IOException {
        writer.write("'");
        Calendar calendar = Helper.allocateCalendar();
        calendar.setTime(date);
        if (calendar.get(2) + 1 < 10) {
            writer.write(48);
        }
        writer.write(Integer.toString(calendar.get(2) + 1));
        writer.write(47);
        if (calendar.get(5) < 10) {
            writer.write(48);
        }
        writer.write(Integer.toString(calendar.get(5)));
        writer.write(47);
        writer.write(Integer.toString(calendar.get(1)));
        writer.write("'");
        Helper.releaseCalendar(calendar);
    }

    protected void appendDB2Timestamp(Timestamp timestamp, Writer writer) throws IOException {
        Calendar calendar = Helper.allocateCalendar();
        calendar.setTime(timestamp);
        writer.write(Helper.printDate(calendar));
        writer.write(45);
        if (calendar.get(11) < 10) {
            writer.write(48);
        }
        writer.write(Integer.toString(calendar.get(11)));
        writer.write(46);
        if (calendar.get(12) < 10) {
            writer.write(48);
        }
        writer.write(Integer.toString(calendar.get(12)));
        writer.write(46);
        if (calendar.get(13) < 10) {
            writer.write(48);
        }
        writer.write(Integer.toString(calendar.get(13)));
        writer.write(46);
        Helper.releaseCalendar(calendar);
        String nanoString = Integer.toString(timestamp.getNanos());
        int numberOfZeros = 0;
        for (int num = Math.min(9 - nanoString.length(), 6); num > 0; --num) {
            writer.write(48);
            ++numberOfZeros;
        }
        if (nanoString.length() + numberOfZeros > 6) {
            nanoString = nanoString.substring(0, 6 - numberOfZeros);
        }
        writer.write(nanoString);
    }

    protected void appendDB2Calendar(Calendar calendar, Writer writer) throws IOException {
        int second;
        int minute;
        int hour;
        if (!Helper.getDefaultTimeZone().equals(calendar.getTimeZone())) {
            Calendar localCalendar = Helper.allocateCalendar();
            JavaPlatform.setTimeInMillis(localCalendar, JavaPlatform.getTimeInMillis(calendar));
            hour = calendar.get(11);
            minute = calendar.get(12);
            second = calendar.get(13);
            Helper.releaseCalendar(localCalendar);
        } else {
            hour = calendar.get(11);
            minute = calendar.get(12);
            second = calendar.get(13);
        }
        writer.write(Helper.printDate(calendar));
        writer.write(45);
        if (hour < 10) {
            writer.write(48);
        }
        writer.write(Integer.toString(hour));
        writer.write(46);
        if (minute < 10) {
            writer.write(48);
        }
        writer.write(Integer.toString(minute));
        writer.write(46);
        if (second < 10) {
            writer.write(48);
        }
        writer.write(Integer.toString(second));
        writer.write(46);
        String millisString = Integer.toString(calendar.get(14));
        int numberOfZeros = 0;
        for (int num = Math.min(3 - millisString.length(), 3); num > 0; --num) {
            writer.write(48);
            ++numberOfZeros;
        }
        if (millisString.length() + numberOfZeros > 3) {
            millisString = millisString.substring(0, 3 - numberOfZeros);
        }
        writer.write(millisString);
    }

    protected void appendTime(Time time, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("'");
            writer.write(Helper.printTime(time));
            writer.write("'");
        } else {
            super.appendTime(time, writer);
        }
    }

    protected void appendTimestamp(Timestamp timestamp, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("'");
            this.appendDB2Timestamp(timestamp, writer);
            writer.write("'");
        } else {
            super.appendTimestamp(timestamp, writer);
        }
    }

    protected void appendCalendar(Calendar calendar, Writer writer) throws IOException {
        if (this.usesNativeSQL()) {
            writer.write("'");
            this.appendDB2Calendar(calendar, writer);
            writer.write("'");
        } else {
            super.appendCalendar(calendar, writer);
        }
    }

    protected Hashtable buildFieldTypes() {
        Hashtable<Class<Timestamp>, FieldTypeDefinition> fieldTypeMapping = new Hashtable<Class<Timestamp>, FieldTypeDefinition>();
        fieldTypeMapping.put(Boolean.class, new FieldTypeDefinition("SMALLINT DEFAULT 0", false));
        fieldTypeMapping.put(Integer.class, new FieldTypeDefinition("INTEGER", false));
        fieldTypeMapping.put(Long.class, new FieldTypeDefinition("INTEGER", false));
        fieldTypeMapping.put(Float.class, new FieldTypeDefinition("FLOAT", false));
        fieldTypeMapping.put(Double.class, new FieldTypeDefinition("FLOAT", false));
        fieldTypeMapping.put(Short.class, new FieldTypeDefinition("SMALLINT", false));
        fieldTypeMapping.put(Byte.class, new FieldTypeDefinition("SMALLINT", false));
        fieldTypeMapping.put(BigInteger.class, new FieldTypeDefinition("BIGINT", false));
        fieldTypeMapping.put(BigDecimal.class, new FieldTypeDefinition("DECIMAL", 15));
        fieldTypeMapping.put(Number.class, new FieldTypeDefinition("DECIMAL", 15));
        fieldTypeMapping.put(String.class, new FieldTypeDefinition("VARCHAR", 255));
        fieldTypeMapping.put(Character.class, new FieldTypeDefinition("CHAR", 1));
        fieldTypeMapping.put(Byte[].class, new FieldTypeDefinition("BLOB", 64000));
        fieldTypeMapping.put(Character[].class, new FieldTypeDefinition("CLOB", 64000));
        fieldTypeMapping.put(byte[].class, new FieldTypeDefinition("BLOB", 64000));
        fieldTypeMapping.put(char[].class, new FieldTypeDefinition("CLOB", 64000));
        fieldTypeMapping.put(Blob.class, new FieldTypeDefinition("BLOB", 64000));
        fieldTypeMapping.put(Clob.class, new FieldTypeDefinition("CLOB", 64000));
        fieldTypeMapping.put(Date.class, new FieldTypeDefinition("DATE", false));
        fieldTypeMapping.put(Time.class, new FieldTypeDefinition("TIME", false));
        fieldTypeMapping.put(Timestamp.class, new FieldTypeDefinition("TIMESTAMP", false));
        return fieldTypeMapping;
    }

    public int getMaxFieldNameSize() {
        return 128;
    }

    public int getMaxForeignKeyNameSize() {
        return 18;
    }

    public Vector getNativeTableInfo(String table, String creator, AbstractSession session) {
        String query = "SELECT * FROM SYSIBM.SYSTABLES WHERE TBCREATOR NOT IN ('SYS', 'SYSTEM')";
        if (table != null) {
            query = table.indexOf(37) != -1 ? query + " AND TBNAME LIKE " + table : query + " AND TBNAME = " + table;
        }
        if (creator != null) {
            query = creator.indexOf(37) != -1 ? query + " AND TBCREATOR LIKE " + creator : query + " AND TBCREATOR = " + creator;
        }
        return session.executeSelectingCall(new SQLCall(query));
    }

    public String getProcedureCallHeader() {
        return "CALL ";
    }

    public String getSelectForUpdateString() {
        return " FOR UPDATE";
    }

    public String getProcedureEndString() {
        return "END";
    }

    public String getProcedureBeginString() {
        return "BEGIN";
    }

    public String getProcedureAsString() {
        return "";
    }

    public boolean shouldPrintOutputTokenAtStart() {
        return true;
    }

    public ValueReadQuery getTimestampQuery() {
        if (this.timestampQuery == null) {
            this.timestampQuery = new ValueReadQuery();
            this.timestampQuery.setSQLString("SELECT DISTINCT CURRENT TIMESTAMP FROM SYSIBM.SYSTABLES");
        }
        return this.timestampQuery;
    }

    protected void initializePlatformOperators() {
        super.initializePlatformOperators();
        this.addOperator(ExpressionOperator.simpleFunction(28, "UCASE"));
        this.addOperator(ExpressionOperator.simpleFunction(29, "LCASE"));
        this.addOperator(this.concatOperator());
        this.addOperator(ExpressionOperator.simpleTwoArgumentFunction(34, "Locate"));
        this.addOperator(ExpressionOperator.simpleFunction(42, "DECIMAL"));
        this.addOperator(ExpressionOperator.simpleFunction(114, "CHAR"));
        this.addOperator(ExpressionOperator.simpleFunction(48, "CHAR"));
        this.addOperator(ExpressionOperator.simpleFunction(53, "DATE"));
    }

    public boolean isDB2() {
        return true;
    }

    public Hashtable maximumNumericValues() {
        Hashtable<Class, Number> values = new Hashtable<Class, Number>();
        values.put(Integer.class, new Integer(Integer.MAX_VALUE));
        values.put(Long.class, new Long(Integer.MAX_VALUE));
        values.put(Float.class, new Float(1.2345679E8f));
        values.put(Double.class, new Double(3.4028234663852886E38));
        values.put(Short.class, new Short(Short.MAX_VALUE));
        values.put(Byte.class, new Byte(127));
        values.put(BigInteger.class, new BigInteger("999999999999999"));
        values.put(BigDecimal.class, new BigDecimal("0.999999999999999"));
        return values;
    }

    public Hashtable minimumNumericValues() {
        Hashtable<Class, Number> values = new Hashtable<Class, Number>();
        values.put(Integer.class, new Integer(Integer.MIN_VALUE));
        values.put(Long.class, new Long(Integer.MIN_VALUE));
        values.put(Float.class, new Float(-1.2345679E8f));
        values.put(Double.class, new Double(1.4E-45f));
        values.put(Short.class, new Short(Short.MIN_VALUE));
        values.put(Byte.class, new Byte(-128));
        values.put(BigInteger.class, new BigInteger("-999999999999999"));
        values.put(BigDecimal.class, new BigDecimal("-0.999999999999999"));
        return values;
    }

    public boolean shouldIgnoreException(SQLException exception) {
        if (exception.getMessage().equals("No data found") || exception.getMessage().equals("No row was found for FETCH, UPDATE or DELETE; or the result of a query is an empty table") || exception.getErrorCode() == 100) {
            return true;
        }
        return super.shouldIgnoreException(exception);
    }

    public boolean shouldUseJDBCOuterJoinSyntax() {
        return false;
    }

    private ExpressionOperator concatOperator() {
        ExpressionOperator exOperator = new ExpressionOperator();
        exOperator.setType(5);
        exOperator.setSelector(31);
        Vector<String> v = new Vector<String>(5);
        v.addElement("VARCHAR(");
        v.addElement(" || ");
        v.addElement(")");
        exOperator.printsAs(v);
        exOperator.bePrefix();
        exOperator.setNodeClass(ClassConstants.FunctionExpression_Class);
        return exOperator;
    }

    public ValueReadQuery buildSelectQueryForNativeSequence() {
        ValueReadQuery selectQuery = new ValueReadQuery();
        StringWriter writer = new StringWriter();
        writer.write("VALUES IDENTITY_VAL_LOCAL()");
        selectQuery.setSQLString(writer.toString());
        return selectQuery;
    }

    public void printFieldIdentityClause(Writer writer) throws ValidationException {
        try {
            writer.write(" GENERATED ALWAYS AS IDENTITY");
        }
        catch (IOException ioException) {
            throw ValidationException.fileError(ioException);
        }
    }

    public boolean shouldNativeSequenceAcquireValueAfterInsert() {
        return true;
    }

    public boolean supportsNativeSequenceNumbers() {
        return true;
    }

    public boolean supportsGlobalTempTables() {
        return true;
    }

    protected String getCreateTempTableSqlPrefix() {
        return "DECLARE GLOBAL TEMPORARY TABLE ";
    }

    public DatabaseTable getTempTableForTable(DatabaseTable table) {
        DatabaseTable tempTable = super.getTempTableForTable(table);
        tempTable.setTableQualifier("session");
        return tempTable;
    }

    protected String getCreateTempTableSqlSuffix() {
        return " ON COMMIT DELETE ROWS NOT LOGGED";
    }

    protected String getCreateTempTableSqlBodyForTable(DatabaseTable table) {
        return " LIKE " + table.getQualifiedName();
    }

    public boolean dontBindUpdateAllQueryUsingTempTables() {
        return true;
    }

    public boolean isNullAllowedInSelectClause() {
        return false;
    }

    public void writeParameterMarker(Writer writer, ParameterExpression parameter) throws IOException {
        String paramaterMarker = "?";
        Object type = parameter.getType();
        if (type != null) {
            BasicTypeHelperImpl typeHelper = BasicTypeHelperImpl.getInstance();
            String castType = null;
            if (typeHelper.isBooleanType(type) || typeHelper.isByteType(type) || typeHelper.isShortType(type)) {
                castType = "SMALLINT";
            } else if (typeHelper.isIntType(type)) {
                castType = "INTEGER";
            } else if (typeHelper.isLongType(type)) {
                castType = "BIGINT";
            } else if (typeHelper.isFloatType(type)) {
                castType = "REAL";
            } else if (typeHelper.isDoubleType(type)) {
                castType = "DOUBLE";
            } else if (typeHelper.isStringType(type)) {
                castType = "VARCHAR(32672)";
            }
            if (castType != null) {
                paramaterMarker = "CAST (? AS " + castType + " )";
            }
        }
        writer.write(paramaterMarker);
    }

    public boolean shouldBindLiterals() {
        return false;
    }
}

