/*
 * Decompiled with CFR 0.152.
 */
package top.nextdoc4j.springboot.configuration;

import io.swagger.v3.oas.models.OpenAPI;
import jakarta.servlet.Filter;
import java.util.concurrent.TimeUnit;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.boot.web.servlet.FilterRegistrationBean;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.core.io.ResourceLoader;
import org.springframework.http.CacheControl;
import org.springframework.web.cors.CorsConfiguration;
import org.springframework.web.cors.CorsConfigurationSource;
import org.springframework.web.cors.UrlBasedCorsConfigurationSource;
import org.springframework.web.filter.CorsFilter;
import org.springframework.web.servlet.config.annotation.ResourceHandlerRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;
import top.nextdoc4j.core.configuration.NextDoc4jProperties;
import top.nextdoc4j.core.constant.NextDoc4jFilterConstant;
import top.nextdoc4j.core.extension.NextDoc4jExtensionOpenApiCustomizer;
import top.nextdoc4j.core.extension.NextDoc4jExtensionResolver;
import top.nextdoc4j.springboot.filter.NextDoc4jBasicAuthFilter;

@ConditionalOnProperty(prefix="nextdoc4j", name={"enabled"}, havingValue="true")
public class NextDoc4jAutoConfiguration {
    @Bean
    @ConfigurationProperties(prefix="nextdoc4j")
    public NextDoc4jProperties getNextDoc4jProperties() {
        return new NextDoc4jProperties();
    }

    @Bean
    public WebMvcConfigurer nextdoc4jWebMvcConfigurer() {
        return new WebMvcConfigurer(){

            public void addResourceHandlers(ResourceHandlerRegistry registry) {
                registry.addResourceHandler(new String[]{"/doc.html"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/"});
                registry.addResourceHandler(new String[]{"/nextdoc/**"}).addResourceLocations(new String[]{"classpath:/META-INF/resources/nextdoc/"}).setCacheControl(CacheControl.maxAge((long)5L, (TimeUnit)TimeUnit.HOURS).cachePublic());
            }
        };
    }

    @Bean
    @ConditionalOnMissingBean(value={CorsFilter.class})
    @ConditionalOnProperty(prefix="nextdoc4j", name={"cors"}, havingValue="true")
    public CorsFilter nextdoc4jCorsFilter() {
        CorsConfiguration config = new CorsConfiguration();
        config.addAllowedOriginPattern("*");
        config.addAllowedHeader("*");
        config.addAllowedMethod("*");
        config.setAllowCredentials(Boolean.valueOf(true));
        config.setMaxAge(Long.valueOf(1800L));
        UrlBasedCorsConfigurationSource source = new UrlBasedCorsConfigurationSource();
        source.registerCorsConfiguration("/**", config);
        return new CorsFilter((CorsConfigurationSource)source);
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="nextdoc4j.extension", name={"enabled"}, havingValue="true")
    public NextDoc4jExtensionResolver nextdoc4jExtensionResolver(ResourceLoader resourceLoader, ApplicationContext applicationContext) {
        return new NextDoc4jExtensionResolver(resourceLoader, applicationContext);
    }

    @Bean
    @ConditionalOnProperty(prefix="nextdoc4j.auth", name={"enabled"}, havingValue="true")
    public FilterRegistrationBean<NextDoc4jBasicAuthFilter> nextdoc4jBasicAuthFilter(NextDoc4jProperties properties, ResourceLoader resourceLoader, OpenAPI openAPI) {
        FilterRegistrationBean registration = new FilterRegistrationBean();
        registration.setFilter((Filter)new NextDoc4jBasicAuthFilter(properties, resourceLoader, openAPI));
        registration.addUrlPatterns(NextDoc4jFilterConstant.BlockedPaths.URL_PATTERNS);
        registration.setOrder(-2147483646);
        registration.setEnabled(properties.isEnabled() && properties.getAuth().isEnabled());
        return registration;
    }

    @Bean
    @ConditionalOnMissingBean
    @ConditionalOnProperty(prefix="nextdoc4j.extension", name={"enabled"}, havingValue="true")
    public NextDoc4jExtensionOpenApiCustomizer nextdoc4jExtensionOpenApiCustomizer(NextDoc4jProperties properties, NextDoc4jExtensionResolver resolver) {
        return new NextDoc4jExtensionOpenApiCustomizer(properties, resolver);
    }
}

