/*
 * Decompiled with CFR 0.152.
 */
package top.nextdoc4j.springboot.filter;

import ch.qos.logback.core.joran.spi.HttpUtil;
import cn.hutool.core.util.StrUtil;
import io.swagger.v3.oas.models.OpenAPI;
import jakarta.servlet.FilterChain;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import jakarta.servlet.http.HttpSession;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Objects;
import java.util.UUID;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.ResourceLoader;
import org.springframework.web.filter.OncePerRequestFilter;
import top.nextdoc4j.core.configuration.NextDoc4jExtension;
import top.nextdoc4j.core.configuration.NextDoc4jProperties;
import top.nextdoc4j.core.configuration.extension.NextDoc4jBasicAuth;
import top.nextdoc4j.core.configuration.extension.NextDoc4jBrand;
import top.nextdoc4j.core.util.NextDoc4jPathMatcherUtils;
import top.nextdoc4j.core.util.NextDoc4jResourceUtils;

public class NextDoc4jBasicAuthFilter
extends OncePerRequestFilter {
    private static final Logger log = LoggerFactory.getLogger(NextDoc4jBasicAuthFilter.class);
    private static final String AUTH_SESSION_KEY = "nextdoc4j_authenticated";
    private static final int SESSION_TIMEOUT_SECONDS = 1800;
    private static final String BASIC_AUTH_PREFIX = "Basic ";
    private static final String LOGOUT_ACTION = "logout";
    private static final String AJAX_HEADER = "X-Requested-With";
    private static final String AJAX_HEADER_VALUE = "XMLHttpRequest";
    private static final String DOC_LOGIN = "classpath:/META-INF/resources/doclogin.html";
    public final NextDoc4jProperties properties;
    private final NextDoc4jBasicAuth basicAuth;
    public final NextDoc4jExtension nextDoc4JExtension;
    private final ResourceLoader resourceLoader;
    private final OpenAPI openAPI;

    public NextDoc4jBasicAuthFilter(NextDoc4jProperties properties, ResourceLoader resourceLoader, OpenAPI openAPI) {
        this.resourceLoader = Objects.requireNonNull(resourceLoader, "ResourceLoader cannot be null");
        this.properties = properties;
        this.openAPI = openAPI;
        this.basicAuth = properties.getAuth();
        this.nextDoc4JExtension = properties.getExtension();
        this.initializeDefaultPassword();
    }

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        String uri = request.getRequestURI();
        String method = request.getMethod();
        if (!this.isAuthenticationRequired(uri)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        if (this.isLogoutRequest(method, request)) {
            this.handleLogout(request, response);
            return;
        }
        if (this.isSessionAuthenticated(request)) {
            filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
            return;
        }
        String authHeader = request.getHeader("Authorization");
        if (authHeader != null && authHeader.startsWith(BASIC_AUTH_PREFIX)) {
            if (this.validateBasicAuthentication(authHeader)) {
                this.createAuthenticatedSession(request);
                this.handleAuthenticationSuccess(request, response);
            } else {
                this.handleAuthenticationFailure(request, response);
            }
            return;
        }
        this.showLoginPage(response);
    }

    private void initializeDefaultPassword() {
        if (this.basicAuth.getPassword() == null || this.basicAuth.getPassword().trim().isEmpty()) {
            String generatedPassword = UUID.randomUUID().toString().replace("-", "");
            this.basicAuth.setPassword(generatedPassword);
            log.info("\u2554\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2557");
            log.info("\u2551                          NextDoc4j \u57fa\u672c\u8ba4\u8bc1\u5df2\u542f\u7528                                        \u2551");
            log.info("\u2551                                                                                      \u2551");
            log.info("\u2551  \u672a\u914d\u7f6e\u5bc6\u7801\uff0c\u5df2\u81ea\u52a8\u751f\u6210\u9ed8\u8ba4\u5bc6\u7801\uff0c\u8bf7\u59a5\u5584\u4fdd\u7ba1\uff1a                                                  \u2551");
            log.info("\u2551  \u5bc6\u7801: {}                                           \u2551", (Object)generatedPassword);
            log.info("\u2551                                                                                      \u2551");
            log.info("\u2551  \u5efa\u8bae\uff1a\u8bf7\u5728\u914d\u7f6e\u6587\u4ef6\u4e2d\u8bbe\u7f6e\u81ea\u5b9a\u4e49\u5bc6\u7801\u4ee5\u786e\u4fdd\u5b89\u5168\u6027                                                 \u2551");
            log.info("\u255a\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u2550\u255d");
        }
    }

    private boolean isAuthenticationRequired(String uri) {
        return NextDoc4jPathMatcherUtils.isAuthenticationRequired((String)uri, (boolean)this.basicAuth.isEnabled());
    }

    private boolean isLogoutRequest(String method, HttpServletRequest request) {
        return HttpUtil.RequestMethod.GET.name().equalsIgnoreCase(method) && LOGOUT_ACTION.equals(request.getParameter("action"));
    }

    private boolean isSessionAuthenticated(HttpServletRequest request) {
        HttpSession session = request.getSession(false);
        return session != null && Boolean.TRUE.equals(session.getAttribute(AUTH_SESSION_KEY));
    }

    private boolean validateBasicAuthentication(String authHeader) {
        try {
            String base64Credentials = authHeader.substring(BASIC_AUTH_PREFIX.length());
            String credentials = new String(Base64.getDecoder().decode(base64Credentials), StandardCharsets.UTF_8);
            int colonIndex = credentials.indexOf(58);
            String password = colonIndex != -1 ? credentials.substring(colonIndex + 1) : credentials;
            return this.basicAuth.getPassword().equals(password);
        }
        catch (Exception e) {
            log.debug("Failed to validate basic authentication", (Throwable)e);
            return false;
        }
    }

    private void createAuthenticatedSession(HttpServletRequest request) {
        HttpSession session = request.getSession(true);
        session.setAttribute(AUTH_SESSION_KEY, (Object)true);
        session.setMaxInactiveInterval(1800);
    }

    private void handleAuthenticationSuccess(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.isAjaxRequest(request)) {
            this.sendJsonResponse(response, 200, true, "\u8ba4\u8bc1\u6210\u529f");
        } else {
            String redirectUrl = this.buildRedirectUrl(request);
            response.sendRedirect(redirectUrl);
        }
    }

    private void handleAuthenticationFailure(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (this.isAjaxRequest(request)) {
            this.sendJsonResponse(response, 401, false, "\u8ba4\u8bc1\u5931\u8d25");
        } else {
            this.clearBrowserAuthCache(response);
        }
    }

    private void handleLogout(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpSession session = request.getSession(false);
        if (session != null) {
            session.invalidate();
        }
        this.clearBrowserAuthCache(response);
        response.sendRedirect(request.getRequestURI());
    }

    private void showLoginPage(HttpServletResponse response) throws IOException {
        response.setStatus(200);
        response.setContentType("text/html;charset=UTF-8");
        this.setNoCacheHeaders(response);
        String loginPageHtml = this.loadLoginPageFromResources();
        response.getWriter().write(loginPageHtml);
    }

    private boolean isAjaxRequest(HttpServletRequest request) {
        String xRequestedWith = request.getHeader(AJAX_HEADER);
        String accept = request.getHeader("Accept");
        if (AJAX_HEADER_VALUE.equals(xRequestedWith)) {
            return true;
        }
        if (accept != null && accept.contains("application/json") && !accept.contains("text/html")) {
            return true;
        }
        return this.isFetchApiRequest(request, accept);
    }

    private boolean isFetchApiRequest(HttpServletRequest request, String accept) {
        String userAgent = request.getHeader("User-Agent");
        String referer = request.getHeader("Referer");
        return accept != null && accept.contains("*/*") && userAgent != null && userAgent.contains("Chrome") && referer != null && referer.contains(request.getServerName());
    }

    private void sendJsonResponse(HttpServletResponse response, int statusCode, boolean success, String message) throws IOException {
        response.setStatus(statusCode);
        response.setContentType("application/json;charset=UTF-8");
        String jsonResponse = "{\n  \"success\": %s,\n  \"message\": \"%s\"\n}\n".formatted(success, NextDoc4jResourceUtils.escapeJsonString((String)message));
        response.getWriter().write(jsonResponse);
    }

    private String buildRedirectUrl(HttpServletRequest request) {
        return request.getRequestURI() + "?t=" + System.currentTimeMillis();
    }

    private void clearBrowserAuthCache(HttpServletResponse response) {
        response.setHeader("WWW-Authenticate", "Basic realm=\"NextDoc4j API Documentation\"");
        this.setNoCacheHeaders(response);
    }

    private void setNoCacheHeaders(HttpServletResponse response) {
        response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
        response.setHeader("Pragma", "no-cache");
        response.setHeader("Expires", "0");
    }

    private String getClientIpAddress(HttpServletRequest request) {
        String clientIp = request.getHeader("X-Forwarded-For");
        if (clientIp == null || clientIp.isEmpty() || "unknown".equalsIgnoreCase(clientIp)) {
            clientIp = request.getHeader("X-Real-IP");
        }
        if (clientIp == null || clientIp.isEmpty() || "unknown".equalsIgnoreCase(clientIp)) {
            clientIp = request.getRemoteAddr();
        }
        if (clientIp != null && clientIp.contains(",")) {
            clientIp = clientIp.split(",")[0].trim();
        }
        return clientIp != null ? clientIp : "unknown";
    }

    private String loadLoginPageFromResources() {
        try {
            String htmlTemplate = NextDoc4jResourceUtils.readResourceContent((String)DOC_LOGIN, (ResourceLoader)this.resourceLoader);
            if (htmlTemplate == null) {
                throw new RuntimeException("\u65e0\u6cd5\u52a0\u8f7d\u767b\u5f55\u9875\u9762\u6a21\u677f");
            }
            if (!this.isTemplateWithPlaceholders(htmlTemplate)) {
                return htmlTemplate;
            }
            return this.processTemplateWithPlaceholders(htmlTemplate);
        }
        catch (Exception e) {
            throw new RuntimeException("\u52a0\u8f7d\u767b\u5f55\u9875\u9762\u8d44\u6e90\u5931\u8d25: " + e.getMessage(), e);
        }
    }

    private boolean isTemplateWithPlaceholders(String template) {
        return template.contains("LOGO_SRC_PLACEHOLDER") || template.contains("LOGO_CLASS_PLACEHOLDER") || template.contains("TITLE_CLASS_PLACEHOLDER") || template.contains("TITLE_PLACEHOLDER") || template.contains("<!-- LOGO_PLACEHOLDER_START -->") || template.contains("<!-- LOGO_PLACEHOLDER_END -->") || template.contains("${title}");
    }

    private String processTemplateWithPlaceholders(String htmlTemplate) {
        String apiTitle;
        NextDoc4jBrand brand;
        String logo = "";
        String title = "NextDoc4j - API\u6587\u6863\u8ba4\u8bc1";
        if (this.nextDoc4JExtension != null && this.nextDoc4JExtension.isEnabled() && (brand = this.nextDoc4JExtension.getBrand()) != null) {
            logo = NextDoc4jResourceUtils.resolveLogo((String)brand.getLogo(), (ResourceLoader)this.resourceLoader);
            if (StrUtil.isNotBlank((CharSequence)brand.getTitle())) {
                title = brand.getTitle();
            }
        }
        if (title.equals("NextDoc4j - API\u6587\u6863\u8ba4\u8bc1") && this.openAPI != null && this.openAPI.getInfo() != null && StrUtil.isNotBlank((CharSequence)(apiTitle = this.openAPI.getInfo().getTitle()))) {
            title = apiTitle;
        }
        if (StrUtil.isNotBlank((CharSequence)logo)) {
            logo = NextDoc4jResourceUtils.ensureDataUrlFormat((String)logo);
            htmlTemplate = this.replacePlaceholder(htmlTemplate, "LOGO_SRC_PLACEHOLDER", logo);
            htmlTemplate = this.replacePlaceholder(htmlTemplate, "LOGO_CLASS_PLACEHOLDER", StrUtil.isBlank((CharSequence)title) ? "logo-only" : "");
            htmlTemplate = this.replacePlaceholder(htmlTemplate, "TITLE_CLASS_PLACEHOLDER", "with-logo");
        } else {
            htmlTemplate = this.removeLogoContainer(htmlTemplate);
            htmlTemplate = this.replacePlaceholder(htmlTemplate, "TITLE_CLASS_PLACEHOLDER", "");
        }
        htmlTemplate = this.replacePlaceholder(htmlTemplate, "TITLE_PLACEHOLDER", NextDoc4jResourceUtils.escapeHtml((String)title));
        htmlTemplate = this.replacePlaceholder(htmlTemplate, "${title}", NextDoc4jResourceUtils.escapeHtml((String)title));
        return htmlTemplate;
    }

    private String replacePlaceholder(String template, String placeholder, String value) {
        if (template.contains(placeholder)) {
            return template.replace(placeholder, value);
        }
        return template;
    }

    private String removeLogoContainer(String htmlTemplate) {
        String startMarker = "<!-- LOGO_PLACEHOLDER_START -->";
        String endMarker = "<!-- LOGO_PLACEHOLDER_END -->";
        int startIndex = htmlTemplate.indexOf(startMarker);
        int endIndex = htmlTemplate.indexOf(endMarker);
        if (startIndex != -1 && endIndex != -1 && endIndex > startIndex) {
            return htmlTemplate.substring(0, startIndex) + htmlTemplate.substring(endIndex += endMarker.length());
        }
        return htmlTemplate;
    }
}

