/*
 * Decompiled with CFR 0.152.
 */
package top.nextdoc4j.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.util.StreamUtils;
import org.springframework.util.StringUtils;

public class NextDoc4jResourceUtils {
    private static final Map<String, String> MIME_TYPE_MAPPING = Map.of("svg", "image/svg+xml", "png", "image/png", "jpg", "image/jpeg", "jpeg", "image/jpeg", "gif", "image/gif", "webp", "image/webp", "ico", "image/x-icon");
    private static final String DEFAULT_MIME_TYPE = "application/octet-stream";
    private static final Map<String, String> LOGO_CACHE = new ConcurrentHashMap<String, String>();
    private static final Map<String, String> CONTENT_CACHE = new ConcurrentHashMap<String, String>();

    private NextDoc4jResourceUtils() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }

    public static String resolveLogo(String logoPath, ResourceLoader resourceLoader) {
        if (!StringUtils.hasText((String)logoPath) || resourceLoader == null) {
            return null;
        }
        String cachedLogo = LOGO_CACHE.get(logoPath);
        if (cachedLogo != null) {
            return cachedLogo;
        }
        try {
            Resource resource = resourceLoader.getResource(logoPath);
            if (!NextDoc4jResourceUtils.isResourceValid(resource)) {
                return null;
            }
            byte[] logoBytes = NextDoc4jResourceUtils.readResourceBytes(resource);
            if (logoBytes == null || logoBytes.length == 0) {
                return null;
            }
            String dataUrl = NextDoc4jResourceUtils.convertToDataUrl(logoBytes, logoPath);
            LOGO_CACHE.put(logoPath, dataUrl);
            return dataUrl;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String convertToDataUrl(byte[] data, String filePath) {
        if (data == null || data.length == 0) {
            return null;
        }
        String mimeType = NextDoc4jResourceUtils.determineMimeType(filePath);
        String base64Data = Base64.getEncoder().encodeToString(data);
        return String.format("data:%s;base64,%s", mimeType, base64Data);
    }

    public static String ensureDataUrlFormat(String logo) {
        if (!StringUtils.hasText((String)logo)) {
            return null;
        }
        if (logo.startsWith("data:")) {
            return logo;
        }
        return "data:image/png;base64," + logo;
    }

    public static String readResourceContent(String location, ResourceLoader resourceLoader) {
        if (!StringUtils.hasText((String)location) || resourceLoader == null) {
            return null;
        }
        String cachedContent = CONTENT_CACHE.get(location);
        if (cachedContent != null) {
            return cachedContent;
        }
        try {
            Resource resource = resourceLoader.getResource(location);
            if (!NextDoc4jResourceUtils.isResourceValid(resource)) {
                return null;
            }
            String content = NextDoc4jResourceUtils.readResourceContent(resource);
            if (content != null) {
                CONTENT_CACHE.put(location, content);
            }
            return content;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static String readResourceContent(Resource resource) throws IOException {
        if (resource == null) {
            return null;
        }
        try (InputStream inputStream = resource.getInputStream();){
            String string = StreamUtils.copyToString((InputStream)inputStream, (Charset)StandardCharsets.UTF_8);
            return string;
        }
    }

    public static byte[] readResourceBytes(Resource resource) throws IOException {
        if (resource == null) {
            return null;
        }
        try (InputStream inputStream = resource.getInputStream();){
            byte[] byArray = StreamUtils.copyToByteArray((InputStream)inputStream);
            return byArray;
        }
    }

    public static String determineMimeType(String filePath) {
        if (!StringUtils.hasText((String)filePath)) {
            return DEFAULT_MIME_TYPE;
        }
        String extension = NextDoc4jResourceUtils.extractFileExtension(filePath);
        if (extension == null) {
            return DEFAULT_MIME_TYPE;
        }
        return MIME_TYPE_MAPPING.getOrDefault(extension.toLowerCase(), DEFAULT_MIME_TYPE);
    }

    public static boolean isSupportedImageFormat(String filePath) {
        if (!StringUtils.hasText((String)filePath)) {
            return false;
        }
        String extension = NextDoc4jResourceUtils.extractFileExtension(filePath);
        return extension != null && MIME_TYPE_MAPPING.containsKey(extension.toLowerCase());
    }

    public static String extractFileExtension(String filePath) {
        if (!StringUtils.hasText((String)filePath)) {
            return null;
        }
        int lastDotIndex = filePath.lastIndexOf(46);
        if (lastDotIndex < 0 || lastDotIndex == filePath.length() - 1) {
            return null;
        }
        return filePath.substring(lastDotIndex + 1);
    }

    public static String extractFileNameWithoutExtension(String filePath) {
        if (!StringUtils.hasText((String)filePath)) {
            return null;
        }
        int lastSlash = Math.max(filePath.lastIndexOf(47), filePath.lastIndexOf(92));
        String fileName = lastSlash >= 0 ? filePath.substring(lastSlash + 1) : filePath;
        int dotIndex = fileName.lastIndexOf(46);
        return dotIndex > 0 ? fileName.substring(0, dotIndex) : fileName;
    }

    public static String extractFileName(String filePath) {
        if (!StringUtils.hasText((String)filePath)) {
            return null;
        }
        int lastSlash = Math.max(filePath.lastIndexOf(47), filePath.lastIndexOf(92));
        return lastSlash >= 0 ? filePath.substring(lastSlash + 1) : filePath;
    }

    public static boolean isResourceValid(Resource resource) {
        if (resource == null) {
            return false;
        }
        try {
            return resource.exists() && resource.isReadable();
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String escapeHtml(String input) {
        if (input == null) {
            return "";
        }
        return input.replace("&", "&amp;").replace("<", "&lt;").replace(">", "&gt;").replace("\"", "&quot;").replace("'", "&#39;");
    }

    public static String escapeJsonString(String str) {
        if (str == null) {
            return "";
        }
        return str.replace("\\", "\\\\").replace("\"", "\\\"").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
    }

    public static void clearAllCaches() {
        LOGO_CACHE.clear();
        CONTENT_CACHE.clear();
    }

    public static void clearLogoCache() {
        LOGO_CACHE.clear();
    }

    public static void clearContentCache() {
        CONTENT_CACHE.clear();
    }

    public static Map<String, Integer> getCacheStats() {
        return Map.of("logoCacheSize", LOGO_CACHE.size(), "contentCacheSize", CONTENT_CACHE.size(), "totalCacheSize", LOGO_CACHE.size() + CONTENT_CACHE.size());
    }

    public static String removeLogoFromCache(String logoPath) {
        return LOGO_CACHE.remove(logoPath);
    }

    public static String removeContentFromCache(String location) {
        return CONTENT_CACHE.remove(location);
    }
}

