/*
 * Decompiled with CFR 0.152.
 */
package top.nextdoc4j.core.util;

import org.springframework.util.AntPathMatcher;
import top.nextdoc4j.core.constant.NextDoc4jFilterConstant;

public class NextDoc4jPathMatcherUtils {
    private static final AntPathMatcher PATH_MATCHER = new AntPathMatcher();
    private static final String[] EXACT_PATTERNS = NextDoc4jFilterConstant.BlockedPaths.getAntExactPatterns();
    private static final String[] PREFIX_PATTERNS = NextDoc4jFilterConstant.BlockedPaths.getAntPrefixPatterns();

    private NextDoc4jPathMatcherUtils() {
        throw new AssertionError((Object)"Utility class should not be instantiated");
    }

    public static boolean shouldBlock(String requestUri) {
        if (requestUri == null || requestUri.isEmpty()) {
            return false;
        }
        for (String pattern : EXACT_PATTERNS) {
            if (!PATH_MATCHER.match(pattern, requestUri)) continue;
            return true;
        }
        for (String pattern : PREFIX_PATTERNS) {
            if (!PATH_MATCHER.match(pattern, requestUri)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAuthenticationRequired(String requestUri, boolean authEnabled) {
        if (!authEnabled) {
            return false;
        }
        return NextDoc4jPathMatcherUtils.shouldBlock(requestUri);
    }

    public static boolean isNextDoc4jResource(String requestUri) {
        if (requestUri == null || requestUri.isEmpty()) {
            return false;
        }
        String docHtmlPattern = NextDoc4jFilterConstant.BlockedPaths.toAntExactPattern("/doc.html");
        String nextdocPattern = NextDoc4jFilterConstant.BlockedPaths.toAntPrefixPattern("/nextdoc/");
        return PATH_MATCHER.match(docHtmlPattern, requestUri) || PATH_MATCHER.match(nextdocPattern, requestUri);
    }

    public static AntPathMatcher getPathMatcher() {
        return PATH_MATCHER;
    }
}

