/*
 * Decompiled with CFR 0.152.
 */
package top.nextdoc4j.core.extension;

import io.swagger.v3.oas.models.OpenAPI;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springdoc.core.customizers.GlobalOpenApiCustomizer;
import top.nextdoc4j.core.configuration.NextDoc4jExtension;
import top.nextdoc4j.core.configuration.NextDoc4jProperties;
import top.nextdoc4j.core.extension.NextDoc4jExtensionResolver;

public class NextDoc4jExtensionOpenApiCustomizer
implements GlobalOpenApiCustomizer {
    private static final Logger log = LoggerFactory.getLogger(NextDoc4jExtensionOpenApiCustomizer.class);
    private final NextDoc4jProperties properties;
    private final NextDoc4jExtensionResolver resolver;

    public NextDoc4jExtensionOpenApiCustomizer(NextDoc4jProperties properties, NextDoc4jExtensionResolver resolver) {
        this.properties = properties;
        this.resolver = resolver;
    }

    public void customise(OpenAPI openApi) {
        try {
            NextDoc4jExtension extension = this.properties.getExtension();
            Map<String, Object> extensionData = this.resolver.buildExtensionData(extension);
            if (!extensionData.isEmpty()) {
                openApi.addExtension("x-nextdoc4j", extensionData);
            }
        }
        catch (Exception e) {
            log.error("Failed to customize OpenAPI with NextDoc4j extensions", (Throwable)e);
        }
    }
}

