/*
 * Copyright (c) 2025-present echo. All Rights Reserved.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *
 * This file is part of the NextDoc4j project.
 */
package top.nextdoc4j.core.constant;

/**
 * 基础常量信息
 *
 * @author echo
 * @since 1.0.0
 **/
public class NextDoc4jBaseConstant {

    /**
     * 是否启用
     */
    public static final String ENABLED = "enabled";

    /**
     * nextdoc4j
     */
    public static final String NEXTDOC4J = "nextdoc4j";

    /**
     * 生产
     */
    public static final String PRODUCTION = "production";

    /**
     * 扩展
     */
    public static final String EXTENSION = NEXTDOC4J + ".extension";

    /**
     * 插件
     */
    public static final String PLUGIN = NEXTDOC4J + ".plugin";

    /**
     * 插件 - 枚举显示插件
     */
    public static final String PLUGIN_ENUM = PLUGIN + ".enum";

    /**
     * 认证
     */
    public static final String AUTH = NEXTDOC4J + ".auth";

}
