/*
 * Decompiled with CFR 0.152.
 */
package top.nextdoc4j.core.util;

import org.springframework.util.AntPathMatcher;
import top.nextdoc4j.core.constant.NextDoc4jFilterConstant;

public class NextDoc4jPathMatcherUtils {
    private static final AntPathMatcher PATH_MATCHER = new AntPathMatcher();
    private static volatile String[] exactPatterns;
    private static volatile String[] prefixPatterns;

    private NextDoc4jPathMatcherUtils() {
        throw new AssertionError((Object)"Utility class should not be instantiated");
    }

    public static boolean shouldBlock(String requestUri) {
        if (requestUri == null || requestUri.isEmpty()) {
            return false;
        }
        for (String pattern : NextDoc4jPathMatcherUtils.getExactPatterns()) {
            if (!PATH_MATCHER.match(pattern, requestUri)) continue;
            return true;
        }
        for (String pattern : NextDoc4jPathMatcherUtils.getPrefixPatterns()) {
            if (!PATH_MATCHER.match(pattern, requestUri)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAuthenticationRequired(String requestUri, boolean authEnabled) {
        if (!authEnabled) {
            return false;
        }
        return NextDoc4jPathMatcherUtils.shouldBlock(requestUri);
    }

    public static boolean isNextDoc4jResource(String requestUri) {
        if (requestUri == null || requestUri.isEmpty()) {
            return false;
        }
        String docHtmlPattern = NextDoc4jFilterConstant.BlockedPaths.toAntExactPattern("/doc.html");
        String nextdocPattern = NextDoc4jFilterConstant.BlockedPaths.toAntPrefixPattern("/nextdoc/");
        return PATH_MATCHER.match(docHtmlPattern, requestUri) || PATH_MATCHER.match(nextdocPattern, requestUri);
    }

    public static AntPathMatcher getPathMatcher() {
        return PATH_MATCHER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String[] getExactPatterns() {
        if (exactPatterns != null) return exactPatterns;
        Class<NextDoc4jPathMatcherUtils> clazz = NextDoc4jPathMatcherUtils.class;
        synchronized (NextDoc4jPathMatcherUtils.class) {
            if (exactPatterns != null) return exactPatterns;
            exactPatterns = NextDoc4jFilterConstant.BlockedPaths.getAntExactPatterns();
            // ** MonitorExit[var0] (shouldn't be in output)
            return exactPatterns;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String[] getPrefixPatterns() {
        if (prefixPatterns != null) return prefixPatterns;
        Class<NextDoc4jPathMatcherUtils> clazz = NextDoc4jPathMatcherUtils.class;
        synchronized (NextDoc4jPathMatcherUtils.class) {
            if (prefixPatterns != null) return prefixPatterns;
            prefixPatterns = NextDoc4jFilterConstant.BlockedPaths.getAntPrefixPatterns();
            // ** MonitorExit[var0] (shouldn't be in output)
            return prefixPatterns;
        }
    }
}

