/*
 * Decompiled with CFR 0.152.
 */
package top.nextdoc4j.core.extension;

import cn.hutool.core.io.unit.DataSizeUtil;
import io.swagger.v3.oas.models.OpenAPI;
import java.io.IOException;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.core.io.support.ResourcePatternResolver;
import org.springframework.core.io.support.ResourcePatternUtils;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;
import top.nextdoc4j.core.configuration.NextDoc4jExtension;
import top.nextdoc4j.core.configuration.extension.NextDoc4jBrand;
import top.nextdoc4j.core.configuration.extension.NextDoc4jMarkdown;
import top.nextdoc4j.core.util.NextDoc4jResourceUtils;

public class NextDoc4jExtensionResolver {
    private static final Logger log = LoggerFactory.getLogger(NextDoc4jExtensionResolver.class);
    private static final String DEFAULT_DOCUMENT_NAME = "\u672a\u547d\u540d\u6587\u6863";
    private static final Set<String> WILDCARD_CHARS = Set.of("*", "?");
    private final ResourceLoader resourceLoader;
    private final ResourcePatternResolver resourcePatternResolver;
    private final ApplicationContext applicationContext;

    public NextDoc4jExtensionResolver(ResourceLoader resourceLoader, ApplicationContext applicationContext) {
        this.resourceLoader = Objects.requireNonNull(resourceLoader, "ResourceLoader cannot be null");
        this.applicationContext = Objects.requireNonNull(applicationContext, "ApplicationContext cannot be null");
        this.resourcePatternResolver = ResourcePatternUtils.getResourcePatternResolver((ResourceLoader)resourceLoader);
    }

    public Map<String, Object> buildExtensionData(NextDoc4jExtension extension) {
        HashMap<String, Object> extensionData = new HashMap<String, Object>();
        if (extension == null) {
            return extensionData;
        }
        try {
            List<Map<String, Object>> markdownData;
            Map<String, Object> brandData = this.buildBrandData(extension.getBrand());
            if (!brandData.isEmpty()) {
                extensionData.put("brand", brandData);
            }
            if (!(markdownData = this.buildMarkdownData(extension.getMarkdown())).isEmpty()) {
                extensionData.put("markdown", markdownData);
            }
        }
        catch (Exception e) {
            log.error("Failed to build extension data", (Throwable)e);
        }
        return extensionData;
    }

    private Map<String, Object> buildBrandData(NextDoc4jBrand brand) {
        HashMap<String, Object> brandData = new HashMap<String, Object>();
        if (brand == null) {
            return brandData;
        }
        try {
            String title;
            String logoBase64 = NextDoc4jResourceUtils.resolveLogo(brand.getLogo(), this.resourceLoader);
            if (logoBase64 != null) {
                brandData.put("logo", logoBase64);
            }
            if (StringUtils.hasText((String)(title = this.resolveTitle(brand.getTitle())))) {
                brandData.put("title", title);
            }
            if (StringUtils.hasText((String)brand.getFooterText())) {
                brandData.put("footerText", brand.getFooterText());
            }
        }
        catch (Exception e) {
            log.error("Error building brand data", (Throwable)e);
        }
        return brandData;
    }

    private String resolveTitle(String customTitle) {
        if (StringUtils.hasText((String)customTitle)) {
            return customTitle;
        }
        try {
            String title;
            OpenAPI openAPI = (OpenAPI)this.applicationContext.getBean(OpenAPI.class);
            if (openAPI.getInfo() != null && StringUtils.hasText((String)(title = openAPI.getInfo().getTitle()))) {
                return title;
            }
        }
        catch (Exception e) {
            log.debug("Failed to get OpenAPI title, using custom title only", (Throwable)e);
        }
        return null;
    }

    private List<Map<String, Object>> buildMarkdownData(List<NextDoc4jMarkdown> markdownList) {
        if (CollectionUtils.isEmpty(markdownList)) {
            return Collections.emptyList();
        }
        ArrayList<Map<String, Object>> result = new ArrayList<Map<String, Object>>();
        for (NextDoc4jMarkdown markdown : markdownList) {
            try {
                if (this.isWildcardPath(markdown.getLocation())) {
                    List<Map<String, Object>> wildcardResults = this.resolveWildcardMarkdown(markdown);
                    result.addAll(wildcardResults);
                    continue;
                }
                Map<String, Object> singleResult = this.resolveSingleMarkdown(markdown);
                if (singleResult == null) continue;
                result.add(singleResult);
            }
            catch (Exception e) {
                log.error("Failed to resolve markdown: {}", (Object)markdown.getLocation(), (Object)e);
            }
        }
        return result;
    }

    private List<Map<String, Object>> resolveWildcardMarkdown(NextDoc4jMarkdown template) {
        ArrayList<Map<String, Object>> results = new ArrayList<Map<String, Object>>();
        String location = template.getLocation();
        try {
            Resource[] resources = this.resourcePatternResolver.getResources(location);
            if (resources.length == 0) {
                return results;
            }
            for (Resource resource : resources) {
                if (!NextDoc4jResourceUtils.isResourceValid(resource)) continue;
                try {
                    String content = NextDoc4jResourceUtils.readResourceContent(resource);
                    Map<String, Object> markdownData = this.createMarkdownDataMap(template, resource, content);
                    results.add(markdownData);
                }
                catch (Exception e) {
                    log.error("Failed to process resource: {}", (Object)resource.getDescription(), (Object)e);
                }
            }
            results.sort(Comparator.comparing(map -> (String)map.get("filename")));
        }
        catch (Exception e) {
            log.error("Failed to resolve wildcard markdown pattern: {}", (Object)location, (Object)e);
        }
        return results;
    }

    private Map<String, Object> createMarkdownDataMap(NextDoc4jMarkdown template, Resource resource, String content) {
        String filename;
        HashMap<String, Object> markdownData = new HashMap<String, Object>();
        if (StringUtils.hasText((String)template.getGroup())) {
            markdownData.put("group", template.getGroup());
        }
        if ((filename = resource.getFilename()) == null) {
            filename = "\u672a\u547d\u540d\u6587\u6863.md";
        }
        String displayName = this.extractFileNameWithoutExtension(filename);
        markdownData.put("filename", filename);
        markdownData.put("displayName", displayName);
        markdownData.put("content", content);
        try {
            LocalDateTime lastModified = Instant.ofEpochMilli(resource.lastModified()).atZone(ZoneId.of("Asia/Shanghai")).toLocalDateTime();
            markdownData.put("lastModified", lastModified);
            markdownData.put("contentLength", DataSizeUtil.format((long)resource.contentLength()));
        }
        catch (IOException e) {
            log.debug("Failed to get resource metadata for: {}", (Object)resource.getDescription());
            markdownData.put("lastModified", 0L);
            markdownData.put("contentLength", content.length());
        }
        return markdownData;
    }

    private Map<String, Object> resolveSingleMarkdown(NextDoc4jMarkdown markdown) {
        String location = markdown.getLocation();
        try {
            Resource resource = this.resourceLoader.getResource(location);
            if (!NextDoc4jResourceUtils.isResourceValid(resource)) {
                return null;
            }
            String content = NextDoc4jResourceUtils.readResourceContent(resource);
            if (content == null) {
                return null;
            }
            return this.createMarkdownDataMap(markdown, resource, content);
        }
        catch (Exception e) {
            log.error("Failed to resolve single markdown: {}", (Object)location, (Object)e);
            return null;
        }
    }

    private String extractFilenameFromLocation(String location) {
        if (!StringUtils.hasText((String)location)) {
            return "\u672a\u547d\u540d\u6587\u6863.md";
        }
        String path = location;
        if (path.contains(":")) {
            path = path.substring(path.lastIndexOf(":") + 1);
        }
        if (path.contains("/")) {
            path = path.substring(path.lastIndexOf("/") + 1);
        } else if (path.contains("\\")) {
            path = path.substring(path.lastIndexOf("\\") + 1);
        }
        return StringUtils.hasText((String)path) ? path : "\u672a\u547d\u540d\u6587\u6863.md";
    }

    private String extractFileNameWithoutExtension(String filename) {
        if (!StringUtils.hasText((String)filename)) {
            return DEFAULT_DOCUMENT_NAME;
        }
        int dotIndex = filename.lastIndexOf(46);
        if (dotIndex > 0) {
            return filename.substring(0, dotIndex);
        }
        return filename;
    }

    private boolean isWildcardPath(String location) {
        if (!StringUtils.hasText((String)location)) {
            return false;
        }
        return WILDCARD_CHARS.stream().anyMatch(location::contains);
    }

    public void clearCache() {
        NextDoc4jResourceUtils.clearAllCaches();
    }

    public Map<String, Integer> getCacheStats() {
        return NextDoc4jResourceUtils.getCacheStats();
    }
}

