/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.util;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.serializer.SerializerFeature;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.InetAddress;
import java.net.URLEncoder;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.ResourceBundle;
import javax.servlet.ServletRequest;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.core.NamedThreadLocal;
import org.springframework.web.util.WebUtils;
import top.ibase4j.core.util.DataUtil;
import top.ibase4j.core.util.ExceptionUtil;
import top.ibase4j.core.util.InstanceUtil;
import top.ibase4j.core.util.XmlUtil;

public final class WebUtil {
    public static ThreadLocal<HttpServletRequest> REQUEST = new NamedThreadLocal("ThreadLocalRequest");
    private static Logger logger = LogManager.getLogger();

    private WebUtil() {
    }

    public static final String getCookieValue(HttpServletRequest request, String cookieName, String defaultValue) {
        Cookie cookie = WebUtils.getCookie((HttpServletRequest)request, (String)cookieName);
        if (cookie == null) {
            return defaultValue;
        }
        return cookie.getValue();
    }

    public static final Object getCurrentUser(HttpServletRequest request) {
        try {
            HttpSession session = request.getSession();
            if (null != session) {
                return session.getAttribute("CURRENT_USER");
            }
        }
        catch (Exception e) {
            logger.error(ExceptionUtil.getStackTraceAsString(e));
        }
        return null;
    }

    public static final void saveCurrentUser(HttpServletRequest request, Object user) {
        WebUtil.setSession(request, "CURRENT_USER", user);
    }

    public static final void setSession(HttpServletRequest request, String key, Object value) {
        HttpSession session = request.getSession();
        if (null != session) {
            session.setAttribute(key, value);
        }
    }

    public static final Object getSession(HttpServletRequest request, String key) {
        HttpSession session = request.getSession();
        if (null != session) {
            return session.getAttribute(key);
        }
        return null;
    }

    public static final void removeCurrentUser(HttpServletRequest request) {
        request.getSession().removeAttribute("CURRENT_USER");
    }

    public static final String getApplicationResource(String key, HttpServletRequest request) {
        ResourceBundle resourceBundle = ResourceBundle.getBundle("ApplicationResources", request.getLocale());
        return resourceBundle.getString(key);
    }

    public static final Map<String, Object> getParameterMap(HttpServletRequest request) {
        return WebUtils.getParametersStartingWith((ServletRequest)request, null);
    }

    public static String getRequestBody(ServletRequest request) {
        String body = (String)request.getAttribute("iBase4J.requestBody");
        if (DataUtil.isEmpty(body)) {
            body = "";
            try {
                String str;
                BufferedReader br = request.getReader();
                while ((str = br.readLine()) != null) {
                    body = body + str;
                }
                logger.info("request body===>{}", (Object)body);
                request.setAttribute("iBase4J.requestBody", (Object)body);
            }
            catch (Exception e) {
                logger.error(ExceptionUtil.getStackTraceAsString(e));
            }
        }
        return body;
    }

    public static Map<String, Object> getRequestParam(String param) {
        HashMap<String, Object> paramMap = InstanceUtil.newHashMap();
        if (null != param) {
            String[] params;
            for (String param2 : params = param.split("&")) {
                String[] p = param2.split("=");
                if (p.length != 2) continue;
                paramMap.put(p[0], p[1]);
            }
        }
        return paramMap;
    }

    public static Map<String, Object> getParameter(HttpServletRequest request) {
        String body = WebUtil.getRequestBody((ServletRequest)request);
        if (DataUtil.isNotEmpty(body)) {
            try {
                return (Map)JSON.parseObject((String)body, Map.class);
            }
            catch (Exception e) {
                logger.error(ExceptionUtil.getStackTraceAsString(e));
                try {
                    return XmlUtil.parseXml2Map(body);
                }
                catch (Exception e1) {
                    logger.error(ExceptionUtil.getStackTraceAsString(e));
                    return WebUtil.getRequestParam(body);
                }
            }
        }
        return WebUtil.getParameterMap(request);
    }

    public static <T> T getParameter(HttpServletRequest request, Class<T> cls) {
        String body = WebUtil.getRequestBody((ServletRequest)request);
        if (DataUtil.isNotEmpty(body)) {
            try {
                return (T)JSON.parseObject((String)body, cls);
            }
            catch (Exception e) {
                logger.error(ExceptionUtil.getStackTraceAsString(e));
                try {
                    return InstanceUtil.parse(body, cls);
                }
                catch (Exception e1) {
                    logger.error(ExceptionUtil.getStackTraceAsString(e));
                }
            }
        }
        return InstanceUtil.transMap2Bean(WebUtil.getParameterMap(request), cls);
    }

    public static final String getHost(HttpServletRequest request) {
        String ip = request.getHeader("X-Forwarded-For");
        if (DataUtil.isEmpty(ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("Proxy-Client-IP");
        }
        if (DataUtil.isEmpty(ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("WL-Proxy-Client-IP");
        }
        if (DataUtil.isEmpty(ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_CLIENT_IP");
        }
        if (DataUtil.isEmpty(ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("HTTP_X_FORWARDED_FOR");
        }
        if (DataUtil.isEmpty(ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getHeader("X-Real-IP");
        }
        if (DataUtil.isEmpty(ip) || "unknown".equalsIgnoreCase(ip)) {
            ip = request.getRemoteAddr();
        }
        if (ip != null && ip.indexOf(",") > 0) {
            String[] ips;
            logger.info(ip);
            for (String ip2 : ips = ip.split(",")) {
                String strIp = ip2;
                if ("unknown".equalsIgnoreCase(strIp)) continue;
                ip = strIp;
                break;
            }
        }
        if ("127.0.0.1".equals(ip) || "0:0:0:0:0:0:0:1".equals(ip)) {
            InetAddress inet = null;
            try {
                inet = InetAddress.getLocalHost();
            }
            catch (UnknownHostException e) {
                logger.error("getCurrentIP", (Throwable)e);
            }
            if (inet != null) {
                ip = inet.getHostAddress();
            }
        }
        logger.info("getRemoteAddr ip: " + ip);
        return ip;
    }

    public static void setResponseFileName(HttpServletRequest request, HttpServletResponse response, String displayName) {
        String userAgent = request.getHeader("User-Agent");
        boolean isIE = false;
        if (userAgent != null && userAgent.toLowerCase().contains("msie")) {
            isIE = true;
        }
        try {
            String displayName2;
            if (isIE) {
                displayName2 = URLEncoder.encode(displayName, "UTF-8");
                displayName2 = displayName2.replaceAll("\\+", "%20");
                response.setHeader("Content-Disposition", "attachment;filename=" + displayName2);
            } else {
                displayName2 = new String(displayName.getBytes("UTF-8"), "ISO8859-1");
                response.setHeader("Content-Disposition", "attachment;filename=\"" + displayName2 + "\"");
            }
            String extStr = displayName2.substring(displayName2.indexOf(".") + 1);
            if ("xls".equalsIgnoreCase(extStr)) {
                response.setContentType("application/vnd.ms-excel charset=UTF-8");
            } else {
                response.setContentType("application/octet-stream");
            }
        }
        catch (UnsupportedEncodingException e) {
            logger.error("\u8bbe\u7f6e\u6587\u4ef6\u540d\u53d1\u751f\u9519\u8bef", (Throwable)e);
        }
    }

    public static boolean isWhiteRequest(String url, int size, List<String> whiteUrls) {
        if (url == null || "".equals(url) || size == 0) {
            return true;
        }
        url = url.toLowerCase();
        for (String urlTemp : whiteUrls) {
            if (url.indexOf(urlTemp.toLowerCase()) <= -1) continue;
            return true;
        }
        return false;
    }

    public static boolean write(HttpServletResponse response, Integer code, String msg) throws IOException {
        response.setContentType("application/json;charset=UTF-8");
        LinkedHashMap modelMap = InstanceUtil.newLinkedHashMap();
        modelMap.put("code", code.toString());
        modelMap.put("msg", msg);
        modelMap.put("timestamp", System.currentTimeMillis());
        logger.info("response===>" + JSON.toJSON(modelMap));
        response.getOutputStream().write(JSON.toJSONBytes(modelMap, (SerializerFeature[])new SerializerFeature[]{SerializerFeature.DisableCircularReferenceDetect}));
        return false;
    }
}

