/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.util;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.regex.Pattern;

public strictfp final class MathUtil {
    private static int DEF_SCALE = 10;

    private MathUtil() {
    }

    public static final BigDecimal bigDecimal(Object object) {
        BigDecimal result;
        if (object == null) {
            throw new NullPointerException();
        }
        try {
            result = new BigDecimal(String.valueOf(object).replaceAll(",", ""));
        }
        catch (NumberFormatException e) {
            throw new NumberFormatException("Please give me a numeral.Not " + object);
        }
        return result;
    }

    public static final Double add(Object num1, Object num2) {
        BigDecimal result = MathUtil.bigDecimal(num1).add(MathUtil.bigDecimal(num2));
        return result.setScale(DEF_SCALE, 4).doubleValue();
    }

    public static final Double subtract(Object num1, Object num2) {
        BigDecimal result = MathUtil.bigDecimal(num1).subtract(MathUtil.bigDecimal(num2));
        return result.setScale(DEF_SCALE, 4).doubleValue();
    }

    public static final Double multiply(Object num1, Object num2) {
        BigDecimal result = MathUtil.bigDecimal(num1).multiply(MathUtil.bigDecimal(num2));
        return result.setScale(DEF_SCALE, 4).doubleValue();
    }

    public static final Double divide(Object num1, Object num2) {
        return MathUtil.divide(num1, num2, DEF_SCALE);
    }

    public static final Double divide(Object num1, Object num2, Integer scale) {
        if (scale == null) {
            scale = DEF_SCALE;
        }
        Object object = num2 = num2 == null || Math.abs(new Double(num2.toString())) == 0.0 ? Integer.valueOf(1) : num2;
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal result = MathUtil.bigDecimal(num1).divide(MathUtil.bigDecimal(num2), (int)scale, 4);
        return result.doubleValue();
    }

    public static final Double round(Object num, int scale) {
        if (scale < 0) {
            throw new IllegalArgumentException("The scale must be a positive integer or zero");
        }
        BigDecimal result = MathUtil.bigDecimal(num).divide(MathUtil.bigDecimal("1"), scale, 4);
        return result.doubleValue();
    }

    public static final BigDecimal getRandom(double start, double end) {
        return new BigDecimal(start + Math.random() * (end - start));
    }

    public static final String format(Object obj, String pattern) {
        if (obj == null) {
            return null;
        }
        if (pattern == null || "".equals(pattern)) {
            pattern = "#";
        }
        DecimalFormat format = new DecimalFormat(pattern);
        return format.format(MathUtil.bigDecimal(obj));
    }

    public static final boolean isNumber(Object object) {
        Pattern pattern = Pattern.compile("\\d+(.\\d+)?$");
        return pattern.matcher(object.toString()).matches();
    }

    public static final void main(String[] args) {
        System.out.println(MathUtil.add(1.000001, 2.1));
    }
}

