/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.support.file.ftp;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPFile;
import org.apache.commons.net.ftp.FTPReply;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.ibase4j.core.exception.FtpException;

public class FtpClient {
    private Logger logger = LogManager.getLogger();
    private static final byte[] LOCK = new byte[]{0};
    private static FTPClient ftpClient = null;
    private Properties properties = null;
    private static final String FILELOCK = "Token.lock";

    public static void main(String[] args) throws Exception {
        String host = "10.116.1.65";
        int port = 21;
        String username = "ftpUser";
        String password = "123456";
        String localUpPath = "C:/bankData/Send/";
        String localDnPath = "C:/bankData/Feedback";
        String remotePath = "Feedback";
        FtpClient ftpClient = new FtpClient(host, port, username, password);
        ftpClient.uploadFile("send", localUpPath);
        ftpClient.downLoadFile(remotePath, localDnPath);
        ftpClient.close();
    }

    public FtpClient() {
    }

    public FtpClient(String host, int port, String username, String password) throws FtpException {
        this.init(host, port, username, password);
    }

    public void open() {
        this.init(this.properties.getProperty("FTPHOSTNAME"), Integer.valueOf(this.properties.getProperty("FTPPORT")), this.properties.getProperty("FTPUSERNAME"), this.properties.getProperty("FTPPASSWORD"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init(String host, int port, String username, String password) throws FtpException {
        byte[] byArray = LOCK;
        synchronized (LOCK) {
            if (ftpClient == null) {
                ftpClient = new FTPClient();
            }
            try {
                ftpClient.connect(host, port);
            }
            catch (Exception e) {
                throw new FtpException("FTP[" + host + ":" + port + "]\u8fde\u63a5\u5931\u8d25!", e);
            }
            if (FTPReply.isPositiveCompletion((int)ftpClient.getReplyCode())) {
                try {
                    ftpClient.login(username, password);
                }
                catch (Exception e) {
                    throw new FtpException("FTP\u7528\u6237[" + username + "]\u767b\u9646\u5931\u8d25!", e);
                }
            } else {
                throw new FtpException("FTP\u8fde\u63a5\u51fa\u9519!");
            }
            this.logger.info("\u7528\u6237[" + username + "]\u767b\u9646[" + host + "]\u6210\u529f.");
            this.properties.setProperty("userName", username);
            this.properties.setProperty("hostName", host);
            try {
                ftpClient.enterLocalPassiveMode();
                ftpClient.setFileTransferMode(10);
                ftpClient.setFileType(2);
            }
            catch (Exception e) {
                this.logger.error("", (Throwable)e);
                throw new FtpException("FTP\u521d\u59cb\u5316\u51fa\u9519!", e);
            }
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() throws FtpException {
        byte[] byArray = LOCK;
        synchronized (LOCK) {
            try {
                ftpClient.logout();
            }
            catch (IOException e) {
                this.logger.error("", (Throwable)e);
                ftpClient = null;
                throw new FtpException("FTP\u9000\u51fa\u767b\u5f55\u51fa\u9519!", e);
            }
            this.logger.info("\u7528\u6237[" + this.properties.getProperty("userName") + "]\u9000\u51fa\u767b\u5f55[" + this.properties.getProperty("hostName") + "].");
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean uploadFile(String remotePath, String localPath) throws FtpException {
        byte[] byArray = LOCK;
        synchronized (LOCK) {
            File file = new File(localPath);
            File[] files = file.listFiles();
            for (int i = 0; i < files.length; ++i) {
                if (this.uploadFiles(files[i], remotePath)) continue;
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return false;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return files.length > 0;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean uploadFiles(File localeFile, String remotePath) throws FtpException {
        byte[] byArray = LOCK;
        synchronized (LOCK) {
            boolean flag22;
            FileInputStream fis;
            block28: {
                boolean flag22;
                block27: {
                    boolean bl;
                    block26: {
                        boolean bl2;
                        block25: {
                            fis = null;
                            try {
                                if (localeFile.isDirectory()) {
                                    boolean flag22 = false;
                                    ftpClient.makeDirectory(localeFile.getName());
                                    ftpClient.changeWorkingDirectory(localeFile.getName());
                                    this.logger.info("[" + localeFile.getAbsolutePath() + "]\u76ee\u5f55");
                                    File[] files = localeFile.listFiles();
                                    for (int i = 0; i < files.length; ++i) {
                                        if (this.uploadFiles(files[i], remotePath + "/" + localeFile.getName())) {
                                            flag22 = true;
                                            continue;
                                        }
                                        bl2 = false;
                                        break block25;
                                    }
                                    ftpClient.changeToParentDirectory();
                                    bl = flag22;
                                    break block26;
                                }
                                if (!FILELOCK.equals(localeFile.getName())) {
                                    fis = new FileInputStream(localeFile);
                                    ftpClient.storeFile(localeFile.getName(), (InputStream)fis);
                                    this.logger.info("[" + localeFile.getAbsolutePath() + "]\u4e0a\u4f20\u6210\u529f!");
                                    flag22 = true;
                                    break block27;
                                }
                                flag22 = true;
                                break block28;
                            }
                            catch (IOException e) {
                                this.logger.error("", (Throwable)e);
                                throw new FtpException("FTP\u4e0a\u4f20[" + localeFile.getAbsolutePath() + "]\u51fa\u9519!", e);
                            }
                        }
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return bl2;
                    }
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return bl;
                }
                // ** MonitorExit[var3_3] (shouldn't be in output)
                return flag22;
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            return flag22;
            finally {
                if (fis != null) {
                    try {
                        fis.close();
                    }
                    catch (IOException iOException) {}
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean downLoadFile(String remotePath, String localPath) throws FtpException {
        byte[] byArray = LOCK;
        synchronized (LOCK) {
            try {
                if (ftpClient.changeWorkingDirectory(remotePath)) {
                    File localdir;
                    FTPFile[] files = ftpClient.listFiles();
                    if (files.length > 0 && !(localdir = new File(localPath)).exists()) {
                        localdir.mkdir();
                    }
                    for (FTPFile ff : files) {
                        if (this.downLoadFile(ff, localPath)) continue;
                        // ** MonitorExit[var3_3] (shouldn't be in output)
                        return false;
                    }
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return files.length > 0;
                }
            }
            catch (IOException e) {
                this.logger.error("", (Throwable)e);
                throw new FtpException("FTP\u4e0b\u8f7d[" + localPath + "]\u51fa\u9519!", e);
            }
            return false;
        }
    }

    public boolean downLoadFile(FTPFile ftpFile, String localPath) {
        String fileLocalPath = localPath + "/" + ftpFile.getName();
        if (ftpFile.isFile()) {
            if (ftpFile.getName().indexOf("?") == -1) {
                OutputStream outputStream = null;
                try {
                    File localFile = new File(fileLocalPath);
                    if (!localFile.getParentFile().exists()) {
                        localFile.getParentFile().mkdirs();
                    }
                    outputStream = new FileOutputStream(localFile);
                    ftpClient.retrieveFile(ftpFile.getName(), outputStream);
                    outputStream.flush();
                    outputStream.close();
                    this.logger.info("[" + localFile.getAbsolutePath() + "]\u4e0b\u8f7d\u6210\u529f!");
                    boolean bl = true;
                    return bl;
                }
                catch (Exception e) {
                    this.logger.error("", (Throwable)e);
                    throw new FtpException("FTP\u4e0b\u8f7d[" + fileLocalPath + "]\u51fa\u9519!", e);
                }
                finally {
                    try {
                        if (outputStream != null) {
                            outputStream.close();
                        }
                    }
                    catch (IOException iOException) {}
                }
            }
        } else {
            File file = new File(fileLocalPath);
            if (!file.exists()) {
                file.mkdirs();
            }
            try {
                if (ftpClient.changeWorkingDirectory(ftpFile.getName())) {
                    this.logger.info("[" + file.getAbsolutePath() + "]\u76ee\u5f55");
                    FTPFile[] files = null;
                    files = ftpClient.listFiles();
                    for (int i = 0; i < files.length; ++i) {
                        this.downLoadFile(files[i], fileLocalPath);
                    }
                    ftpClient.changeToParentDirectory();
                    return true;
                }
            }
            catch (Exception e) {
                this.logger.error("", (Throwable)e);
                throw new FtpException("FTP\u4e0b\u8f7d[" + fileLocalPath + "]\u51fa\u9519!", e);
            }
        }
        return false;
    }

    public String getMaxFileName(String remotePath) {
        try {
            ftpClient.changeWorkingDirectory(remotePath);
            FTPFile[] files = ftpClient.listFiles();
            Arrays.sort(files, new Comparator<FTPFile>(){

                @Override
                public int compare(FTPFile o1, FTPFile o2) {
                    return o2.getName().compareTo(o1.getName());
                }
            });
            return files[0].getName();
        }
        catch (IOException e) {
            this.logger.error("", (Throwable)e);
            throw new FtpException("FTP\u8bbf\u95ee\u76ee\u5f55[" + remotePath + "]\u51fa\u9519!", e);
        }
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public void setProperties(Map<String, String> properties) {
        this.properties = new Properties();
        String[] key = new String[]{"FTPHOSTNAME", "FTPPORT", "FTPUSERNAME", "FTPPASSWORD"};
        for (int i = 0; i < key.length; ++i) {
            this.properties.put(key[i], properties.get(key[i]));
        }
    }
}

