/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.util;

import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.fileupload.FileItem;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.ibase4j.core.support.excel.Excel2003Reader;
import top.ibase4j.core.support.excel.Excel2007Reader;
import top.ibase4j.core.support.excel.IRowReader;

public final class ExcelReaderUtil {
    private static final Logger logger = LogManager.getLogger();
    public static final String EXCEL03_EXTENSION = ".xls";
    public static final String EXCEL07_EXTENSION = ".xlsx";

    private ExcelReaderUtil() {
    }

    public static void readExcel(IRowReader reader, String fileName) throws Exception {
        if (fileName.endsWith(EXCEL03_EXTENSION)) {
            Excel2003Reader excel03 = new Excel2003Reader(reader);
            excel03.process(fileName);
        } else if (fileName.endsWith(EXCEL07_EXTENSION)) {
            Excel2007Reader excel07 = new Excel2007Reader(reader);
            excel07.process(fileName);
        } else {
            throw new Exception("\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff0cfileName\u7684\u6269\u5c55\u540d\u53ea\u80fd\u662fxls\u6216xlsx\u3002");
        }
    }

    public static void readExcel(IRowReader reader, String fileName, InputStream inputStream) throws Exception {
        if (fileName.endsWith(EXCEL03_EXTENSION)) {
            Excel2003Reader excel03 = new Excel2003Reader(reader);
            excel03.process(inputStream);
        } else if (fileName.endsWith(EXCEL07_EXTENSION)) {
            Excel2007Reader excel07 = new Excel2007Reader(reader);
            excel07.process(inputStream);
        } else {
            throw new Exception("\u6587\u4ef6\u683c\u5f0f\u9519\u8bef\uff0cfileName\u7684\u6269\u5c55\u540d\u53ea\u80fd\u662fxls\u6216xlsx\u3002");
        }
    }

    public static final List<String[]> excelToArrayList(String filePath, int ... sheetNumber) throws Exception {
        List<String[]> resultList = null;
        try (FileInputStream is = null;){
            is = new FileInputStream(filePath);
            resultList = ExcelReaderUtil.excelToArrayList(filePath, is, sheetNumber);
        }
        return resultList;
    }

    public static final List<String[]> excelToArrayList(String fileName, FileItem fileItem, int ... sheetNumber) throws Exception {
        List<String[]> resultList = null;
        try (InputStream is = null;){
            is = fileItem.getInputStream();
            resultList = ExcelReaderUtil.excelToArrayList(fileName, is, sheetNumber);
        }
        return resultList;
    }

    public static final List<String[]> excelToArrayList(String fileName, InputStream is, final int ... sheetNumber) throws Exception {
        final ArrayList<String[]> resultList = new ArrayList<String[]>();
        try {
            ExcelReaderUtil.readExcel(new IRowReader(){

                @Override
                public void getRows(int sheetIndex, int curRow, List<String> rowlist) {
                    if (sheetNumber == null || sheetNumber.length == 0) {
                        resultList.add(rowlist.toArray(new String[0]));
                    } else {
                        for (int k = 0; k < sheetNumber.length; ++k) {
                            if (sheetIndex != sheetNumber[k]) continue;
                            resultList.add(rowlist.toArray(new String[0]));
                        }
                    }
                }
            }, fileName, is);
        }
        catch (Exception e) {
            logger.error("Read excel error.", (Throwable)e);
            throw e;
        }
        return resultList;
    }
}

