/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.support.login;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.httpclient.NameValuePair;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.ibase4j.core.support.context.Resources;
import top.ibase4j.core.support.login.ThirdPartyUser;
import top.ibase4j.core.util.HttpUtil;

public final class ThirdPartyLoginHelper {
    private static final Logger logger = LogManager.getLogger();

    public static final ThirdPartyUser getQQUserinfo(String token, String openid) throws Exception {
        ThirdPartyUser user = new ThirdPartyUser();
        String url = Resources.THIRDPARTY.getString("getUserInfoURL_qq");
        String res = HttpUtil.get(url = url + "?format=json&access_token=" + token + "&oauth_consumer_key=" + Resources.THIRDPARTY.getString("app_id_qq") + "&openid=" + openid);
        JSONObject json = JSON.parseObject((String)res);
        if (json.getIntValue("ret") == 0) {
            user.setUserName(json.getString("nickname"));
            String img = json.getString("figureurl_qq_2");
            if (img == null || "".equals(img)) {
                img = json.getString("figureurl_qq_1");
            }
            user.setAvatarUrl(img);
            String sex = json.getString("gender");
            if ("\u5973".equals(sex)) {
                user.setGender("0");
            } else {
                user.setGender("1");
            }
        } else {
            throw new IllegalArgumentException(json.getString("msg"));
        }
        return user;
    }

    public static final ThirdPartyUser getWxUserinfo(String token, String openid) throws Exception {
        ThirdPartyUser user = new ThirdPartyUser();
        String url = Resources.THIRDPARTY.getString("getUserInfoURL_wx");
        String res = HttpUtil.get(url = url + "?access_token=" + token + "&openid=" + openid);
        JSONObject json = JSON.parseObject((String)res);
        if (json.getString("errcode") == null) {
            String sex;
            user.setUserName(json.getString("nickname"));
            String img = json.getString("headimgurl");
            if (img != null && !"".equals(img)) {
                user.setAvatarUrl(img);
            }
            if ("0".equals(sex = json.getString("sex"))) {
                user.setGender("0");
            } else {
                user.setGender("1");
            }
        } else {
            throw new IllegalArgumentException(json.getString("errmsg"));
        }
        return user;
    }

    public static final ThirdPartyUser getSinaUserinfo(String token, String uid) throws Exception {
        ThirdPartyUser user = new ThirdPartyUser();
        String url = Resources.THIRDPARTY.getString("getUserInfoURL_sina");
        url = url + "?access_token=" + token + "&uid=" + uid;
        String res = HttpUtil.get(url);
        JSONObject json = JSON.parseObject((String)res);
        String name = json.getString("name");
        String nickName = StringUtils.isBlank((CharSequence)json.getString("screen_name")) ? name : json.getString("screen_name");
        user.setAvatarUrl(json.getString("avatar_large"));
        user.setUserName(nickName);
        if ("f".equals(json.getString("gender"))) {
            user.setGender("0");
        } else {
            user.setGender("1");
        }
        user.setToken(token);
        user.setOpenid(uid);
        user.setProvider("sina");
        return user;
    }

    public static final Map<String, String> getQQTokenAndOpenid(String code, String host) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        String tokenUrl = Resources.THIRDPARTY.getString("accessTokenURL_qq");
        String tokenRes = HttpUtil.get(tokenUrl = tokenUrl + "?grant_type=authorization_code&client_id=" + Resources.THIRDPARTY.getString("app_id_qq") + "&client_secret=" + Resources.THIRDPARTY.getString("app_key_qq") + "&code=" + code + "&redirect_uri=http://" + host + Resources.THIRDPARTY.getString("redirect_url_qq"));
        if (tokenRes == null || tokenRes.indexOf("access_token") <= -1) {
            throw new IllegalArgumentException(Resources.getMessage("THIRDPARTY.LOGIN.NOTOKEN", "QQ"));
        }
        Map<String, String> tokenMap = ThirdPartyLoginHelper.toMap(tokenRes);
        map.put("access_token", tokenMap.get("access_token"));
        String openIdUrl = Resources.THIRDPARTY.getString("getOpenIDURL_qq");
        openIdUrl = openIdUrl + "?access_token=" + tokenMap.get("access_token");
        String openIdRes = HttpUtil.get(openIdUrl);
        int i = openIdRes.indexOf("(");
        int j = openIdRes.indexOf(")");
        openIdRes = openIdRes.substring(i + 1, j);
        JSONObject openidObj = JSON.parseObject((String)openIdRes);
        map.put("openId", openidObj.getString("openid"));
        return map;
    }

    public static final Map<String, String> getWxTokenAndOpenid(String code, String host) throws Exception {
        HashMap<String, String> map = new HashMap<String, String>();
        String tokenUrl = Resources.THIRDPARTY.getString("accessTokenURL_wx");
        String tokenRes = HttpUtil.get(tokenUrl = tokenUrl + "?appid=" + Resources.THIRDPARTY.getString("app_id_wx") + "&secret=" + Resources.THIRDPARTY.getString("app_key_wx") + "&code=" + code + "&grant_type=authorization_code");
        if (tokenRes == null || tokenRes.indexOf("access_token") <= -1) {
            throw new IllegalArgumentException(Resources.getMessage("THIRDPARTY.LOGIN.NOTOKEN", "weixin"));
        }
        Map<String, String> tokenMap = ThirdPartyLoginHelper.toMap(tokenRes);
        map.put("access_token", tokenMap.get("access_token"));
        map.put("openId", tokenMap.get("openid"));
        return map;
    }

    public static final JSONObject getSinaTokenAndUid(String code, String host) {
        JSONObject json = null;
        try {
            String tokenUrl = Resources.THIRDPARTY.getString("accessTokenURL_sina");
            ArrayList<NameValuePair> list = new ArrayList<NameValuePair>();
            NameValuePair params1 = new NameValuePair();
            params1.setName("client_id");
            params1.setValue(Resources.THIRDPARTY.getString("app_id_sina"));
            list.add(params1);
            NameValuePair params2 = new NameValuePair();
            params2.setName("client_secret");
            params2.setValue(Resources.THIRDPARTY.getString("app_key_sina"));
            list.add(params2);
            NameValuePair params3 = new NameValuePair();
            params3.setName("grant_type");
            params3.setValue("authorization_code");
            list.add(params3);
            NameValuePair params4 = new NameValuePair();
            params4.setName("redirect_uri");
            params4.setValue("http://" + host + Resources.THIRDPARTY.getString("redirect_url_sina"));
            list.add(params4);
            NameValuePair params5 = new NameValuePair();
            params5.setName("code");
            params5.setValue(code);
            list.add(params5);
            String tokenRes = HttpUtil.post(tokenUrl, list);
            if (tokenRes == null || tokenRes.indexOf("access_token") <= -1) {
                throw new IllegalArgumentException(Resources.getMessage("THIRDPARTY.LOGIN.NOTOKEN", "sina"));
            }
            json = JSON.parseObject((String)tokenRes);
        }
        catch (Exception e) {
            logger.error("", (Throwable)e);
        }
        return json;
    }

    private static final Map<String, String> toMap(String str) {
        String[] strs;
        HashMap<String, String> map = new HashMap<String, String>();
        for (String str2 : strs = str.split("&")) {
            String[] ss = str2.split("=");
            map.put(ss[0], ss[1]);
        }
        return map;
    }
}

