/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.support.cache;

import java.io.Serializable;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import org.springframework.dao.DataAccessException;
import org.springframework.data.redis.connection.RedisConnection;
import org.springframework.data.redis.connection.RedisStringCommands;
import org.springframework.data.redis.core.RedisCallback;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.data.redis.core.script.DefaultRedisScript;
import org.springframework.data.redis.core.script.RedisScript;
import org.springframework.data.redis.core.types.Expiration;
import org.springframework.data.redis.serializer.RedisSerializer;
import org.springframework.util.Assert;
import top.ibase4j.core.support.cache.CacheManager;
import top.ibase4j.core.support.context.ApplicationContextHolder;
import top.ibase4j.core.util.CacheUtil;
import top.ibase4j.core.util.InstanceUtil;
import top.ibase4j.core.util.PropertiesUtil;

public final class RedisHelper
implements CacheManager {
    private RedisTemplate<Serializable, Serializable> redisTemplate;
    private final Integer EXPIRE = PropertiesUtil.getInt("redis.expiration");

    public RedisHelper(RedisTemplate<Serializable, Serializable> redisTemplate) {
        this.redisTemplate = redisTemplate;
        CacheUtil.setCacheManager(this);
    }

    public RedisTemplate<Serializable, Serializable> getRedisTemplate() {
        if (this.redisTemplate == null) {
            logger.warn("redisTemplate is null");
            this.redisTemplate = (RedisTemplate)ApplicationContextHolder.getBean("lockRedisTemplate");
        }
        return this.redisTemplate;
    }

    @Override
    public final Object get(String key) {
        return this.getRedisTemplate().boundValueOps((Object)key).get();
    }

    @Override
    public final Object get(String key, Integer expire) {
        this.expire(key, expire);
        return this.getRedisTemplate().boundValueOps((Object)key).get();
    }

    @Override
    public final Object getFire(String key) {
        this.expire(key, this.EXPIRE);
        return this.getRedisTemplate().boundValueOps((Object)key).get();
    }

    @Override
    public final Set<Object> getAll(String pattern) {
        HashSet<Object> values = InstanceUtil.newHashSet();
        Set keys = this.getRedisTemplate().keys((Object)pattern);
        for (Serializable key : keys) {
            values.add(this.getRedisTemplate().opsForValue().get((Object)key));
        }
        return values;
    }

    @Override
    public final Set<Object> getAll(String pattern, Integer expire) {
        HashSet<Object> values = InstanceUtil.newHashSet();
        Set keys = this.getRedisTemplate().keys((Object)pattern);
        for (Serializable key : keys) {
            this.expire(key.toString(), expire);
            values.add(this.getRedisTemplate().opsForValue().get((Object)key));
        }
        return values;
    }

    @Override
    public final void set(String key, Serializable value, int seconds) {
        this.getRedisTemplate().boundValueOps((Object)key).set((Object)value);
        this.expire(key, seconds);
    }

    @Override
    public final void set(String key, Serializable value) {
        this.getRedisTemplate().boundValueOps((Object)key).set((Object)value);
        this.expire(key, this.EXPIRE);
    }

    @Override
    public final Boolean exists(String key) {
        return this.getRedisTemplate().hasKey((Object)key);
    }

    @Override
    public final void del(String key) {
        this.getRedisTemplate().delete((Object)key);
    }

    @Override
    public final void delAll(String pattern) {
        this.getRedisTemplate().delete((Collection)this.getRedisTemplate().keys((Object)pattern));
    }

    @Override
    public final String type(String key) {
        return this.getRedisTemplate().type((Object)key).getClass().getName();
    }

    @Override
    public final Boolean expire(String key, int seconds) {
        return this.getRedisTemplate().expire((Object)key, (long)seconds, TimeUnit.SECONDS);
    }

    @Override
    public final Boolean expireAt(String key, long unixTime) {
        return this.getRedisTemplate().expireAt((Object)key, new Date(unixTime));
    }

    @Override
    public final Long ttl(String key) {
        return this.getRedisTemplate().getExpire((Object)key, TimeUnit.SECONDS);
    }

    @Override
    public final void setrange(String key, long offset, String value) {
        this.getRedisTemplate().boundValueOps((Object)key).set((Object)value, offset);
    }

    @Override
    public final String getrange(String key, long startOffset, long endOffset) {
        return this.getRedisTemplate().boundValueOps((Object)key).get(startOffset, endOffset);
    }

    @Override
    public final Object getSet(String key, Serializable value) {
        return this.getRedisTemplate().boundValueOps((Object)key).getAndSet((Object)value);
    }

    @Override
    public boolean setnx(String key, Serializable value) {
        return this.getRedisTemplate().boundValueOps((Object)key).setIfAbsent((Object)value);
    }

    private byte[] rawKey(Object key) {
        Assert.notNull((Object)key, (String)"non null key required");
        RedisSerializer keySerializer = this.getRedisTemplate().getKeySerializer();
        if (keySerializer == null && key instanceof byte[]) {
            return (byte[])key;
        }
        return keySerializer.serialize(key);
    }

    private byte[] rawValue(Object value) {
        RedisSerializer valueSerializer = this.getRedisTemplate().getValueSerializer();
        if (valueSerializer == null && value instanceof byte[]) {
            return (byte[])value;
        }
        return valueSerializer.serialize(value);
    }

    @Override
    public boolean lock(final String key, final String requestId, final long seconds) {
        return (Boolean)this.getRedisTemplate().execute((RedisCallback)new RedisCallback<Boolean>(){

            public Boolean doInRedis(RedisConnection connection) throws DataAccessException {
                return connection.set(RedisHelper.this.rawKey(key), RedisHelper.this.rawValue(requestId), Expiration.seconds((long)seconds), RedisStringCommands.SetOption.ifAbsent());
            }
        });
    }

    @Override
    public boolean unlock(String key, String requestId) {
        String script = "if redis.call('get', KEYS[1]) == ARGV[1] then return redis.call('del', KEYS[1]) else return 0 end";
        return (Boolean)this.getRedisTemplate().execute((RedisScript)new DefaultRedisScript(script, Boolean.class), InstanceUtil.newArrayList(key), new Object[]{requestId});
    }

    @Override
    public void hset(String key, Serializable field, Serializable value) {
        this.getRedisTemplate().boundHashOps((Object)key).put((Object)field, (Object)value);
    }

    @Override
    public Object hget(String key, Serializable field) {
        return this.getRedisTemplate().boundHashOps((Object)key).get((Object)field);
    }

    @Override
    public void hdel(String key, Serializable field) {
        this.getRedisTemplate().boundHashOps((Object)key).delete(new Object[]{field});
    }

    @Override
    public Long incr(String key) {
        return this.getRedisTemplate().boundValueOps((Object)key).increment(1L);
    }
}

