/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.support;

import java.beans.Transient;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class Pagination<T>
implements Serializable {
    public static final int NO_ROW_OFFSET = 0;
    public static final int NO_ROW_LIMIT = Integer.MAX_VALUE;
    private final int offset;
    private final int limit;
    private long total;
    private int size = 10;
    private int pages;
    private int current = 1;
    private boolean searchCount = true;
    private boolean openSort = true;
    private boolean optimizeCountSql = true;
    private List<String> ascs;
    private List<String> descs;
    private boolean isAsc = true;
    private String orderByField;
    private List<T> records = Collections.emptyList();
    private Map<String, Object> condition;

    public Pagination() {
        this.offset = 0;
        this.limit = Integer.MAX_VALUE;
    }

    public Pagination(int current, int size) {
        this(current, size, true);
    }

    public Pagination(int current, int size, boolean searchCount) {
        this(current, size, searchCount, true);
    }

    public Pagination(int current, int size, boolean searchCount, boolean openSort) {
        this.offset = this.offsetCurrent(current, size);
        this.limit = size;
        if (current > 1) {
            this.current = current;
        }
        this.size = size;
        this.searchCount = searchCount;
        this.openSort = openSort;
    }

    public Pagination(int current, int size, String orderByField) {
        this(current, size);
        this.setOrderByField(orderByField);
    }

    public Pagination(int current, int size, String orderByField, boolean isAsc) {
        this(current, size, orderByField);
        this.setAsc(isAsc);
    }

    public long getTotal() {
        return this.total;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public int getSize() {
        return this.size;
    }

    public void setSize(int size) {
        this.size = size;
    }

    public int getPages() {
        return this.pages;
    }

    public void setPages(int pages) {
        this.pages = pages;
    }

    public int getCurrent() {
        return this.current;
    }

    public void setCurrent(int current) {
        this.current = current;
    }

    public boolean isSearchCount() {
        return this.searchCount;
    }

    public void setSearchCount(boolean searchCount) {
        this.searchCount = searchCount;
    }

    public boolean isOpenSort() {
        return this.openSort;
    }

    public void setOpenSort(boolean openSort) {
        this.openSort = openSort;
    }

    public boolean isOptimizeCountSql() {
        return this.optimizeCountSql;
    }

    public void setOptimizeCountSql(boolean optimizeCountSql) {
        this.optimizeCountSql = optimizeCountSql;
    }

    public List<String> getAscs() {
        return this.ascs;
    }

    public void setAscs(List<String> ascs) {
        this.ascs = ascs;
    }

    public List<String> getDescs() {
        return this.descs;
    }

    public void setDescs(List<String> descs) {
        this.descs = descs;
    }

    public boolean isAsc() {
        return this.isAsc;
    }

    public void setAsc(boolean isAsc) {
        this.isAsc = isAsc;
    }

    public String getOrderByField() {
        return this.orderByField;
    }

    public void setOrderByField(String orderByField) {
        this.orderByField = orderByField;
    }

    public int getOffset() {
        return this.offset;
    }

    public int getLimit() {
        return this.limit;
    }

    public List<T> getRecords() {
        return this.records;
    }

    public Pagination<T> setRecords(List<T> records) {
        this.records = records;
        return this;
    }

    @Transient
    public Map<String, Object> getCondition() {
        return this.condition;
    }

    public Pagination<T> setCondition(Map<String, Object> condition) {
        this.condition = condition;
        return this;
    }

    public int offsetCurrent(int current, int size) {
        if (current > 0) {
            return (current - 1) * size;
        }
        return 0;
    }

    public int offsetCurrent(Pagination<T> page) {
        if (null == page) {
            return 0;
        }
        return this.offsetCurrent(page.getCurrent(), page.getSize());
    }
}

