/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.filter;

import java.io.IOException;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.ibase4j.core.filter.CsrfFilter;
import top.ibase4j.core.support.HttpCode;
import top.ibase4j.core.support.Token;
import top.ibase4j.core.util.DataUtil;
import top.ibase4j.core.util.FileUtil;
import top.ibase4j.core.util.PropertiesUtil;
import top.ibase4j.core.util.TokenUtil;
import top.ibase4j.core.util.WebUtil;

public class TokenFilter
implements Filter {
    private Logger logger = LogManager.getLogger();
    private String expire;
    private List<String> whiteUrls;
    private int _size = 0;

    public void init(FilterConfig config) throws ServletException {
        this.logger.info("init TokenFilter..");
        String path = CsrfFilter.class.getResource("/").getFile();
        this.whiteUrls = FileUtil.readFile(path + "white/tokenWhite.txt");
        this._size = null == this.whiteUrls ? 0 : this.whiteUrls.size();
        this.expire = config.getInitParameter("expire");
    }

    public void doFilter(ServletRequest servletRequest, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        String url;
        HttpServletRequest request = (HttpServletRequest)servletRequest;
        boolean filter = DataUtil.isEmpty(PropertiesUtil.getString("token.filter.test"));
        String token = request.getHeader("UUID");
        this.logger.info("UUID==>" + token);
        if (StringUtils.isNotBlank((CharSequence)token)) {
            try {
                Token tokenInfo = TokenUtil.getTokenInfo(token);
                if (tokenInfo != null) {
                    request.setAttribute("CURRENT_USER", (Object)tokenInfo.getValue());
                    if (DataUtil.isNotEmpty(this.expire) && System.currentTimeMillis() - tokenInfo.getTime() > Long.valueOf(this.expire) * 1000L) {
                        this.logger.info("UUID==>{}\u8fc7\u671f", (Object)token);
                        request.removeAttribute("CURRENT_USER");
                    }
                } else {
                    this.logger.info("UUID==>{}\u65e0\u6548", (Object)token);
                }
            }
            catch (Exception e) {
                this.logger.error("token\u68c0\u67e5\u53d1\u751f\u5f02\u5e38:", (Throwable)e);
            }
        }
        if (WebUtil.isWhiteRequest(url = request.getRequestURI(), this._size, this.whiteUrls)) {
            chain.doFilter((ServletRequest)request, response);
        } else if (DataUtil.isEmpty(request.getAttribute("CURRENT_USER")) && filter) {
            WebUtil.write((HttpServletResponse)response, HttpCode.UNAUTHORIZED.value(), HttpCode.UNAUTHORIZED.msg());
        } else {
            chain.doFilter((ServletRequest)request, response);
        }
    }

    public void destroy() {
        this.logger.info("destroy TokenFilter.");
    }
}

