package top.ibase4j.core.util;

import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;

/**
 * @author ShenHuaJie
 * @since 2018年6月14日 下午3:48:25
 */
public class GaodeMapUtil {

    /** 根据地址获取坐标 */
    public static Map<String, Object> getCoordinateByAddress(String address,
        String city) {
        String url = PropertiesUtil.getString("gaode.map.url");
        String key = PropertiesUtil.getString("gaode.map.key");
        url = MessageFormat.format(url, key, address, city);
        String result = HttpUtil.get(url);
        JSONObject jsonObject = JSON.parseObject(result);
        JSONArray pois = (JSONArray)jsonObject.get("pois");
        JSONObject jobj = (JSONObject)pois.get(0);
        String location = jobj.getString("location");
        String[] locs = location.split(",");
        Map<String, Object> map = new HashMap<>();
        map.put("xIndex", locs[0]);
        map.put("yIndex", locs[1]);
        return map;
    }
}
