/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.interceptor;

import com.alibaba.fastjson.JSON;
import io.swagger.annotations.ApiOperation;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.springframework.core.NamedThreadLocal;
import org.springframework.web.method.HandlerMethod;
import top.ibase4j.core.base.IBaseService;
import top.ibase4j.core.interceptor.BaseInterceptor;
import top.ibase4j.core.support.context.ApplicationContextHolder;
import top.ibase4j.core.util.DateUtil;
import top.ibase4j.core.util.ExceptionUtil;
import top.ibase4j.core.util.WebUtil;
import top.ibase4j.model.SysEvent;

public class EventInterceptor
extends BaseInterceptor {
    private final ThreadLocal<Long> startTimeThreadLocal = new NamedThreadLocal("ThreadLocalStartTime");
    private final ThreadLocal<Object> currentUserThreadLocal = new NamedThreadLocal("ThreadLocalCurrentUser");
    protected ExecutorService executorService = Executors.newCachedThreadPool();
    private IBaseService<SysEvent> sysEventService;

    @Override
    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        String path = request.getServletPath();
        this.startTimeThreadLocal.set(System.currentTimeMillis());
        if (!path.contains("login")) {
            try {
                this.currentUserThreadLocal.set(WebUtil.getCurrentUser(request));
            }
            catch (Throwable e) {
                logger.error("", e);
            }
        }
        return super.preHandle(request, response, handler);
    }

    @Override
    public void afterCompletion(HttpServletRequest request, HttpServletResponse response, Object handler, final Exception ex) throws Exception {
        String path;
        Long endTime;
        Long startTime;
        block15: {
            startTime = this.startTimeThreadLocal.get();
            endTime = System.currentTimeMillis();
            path = request.getServletPath();
            if (handler instanceof HandlerMethod) {
                try {
                    String userAgent = request.getHeader("USER-AGENT");
                    String clientIp = WebUtil.getHost(request);
                    Object uid = null;
                    if (!path.contains("login")) {
                        uid = this.currentUserThreadLocal.get();
                    }
                    Object object = uid = uid == null ? WebUtil.getCurrentUser(request) : uid;
                    if (!(path.contains("/error") || path.contains("/read/") || path.contains("/get") || path.contains("/unauthorized") || path.contains("/forbidden"))) {
                        final SysEvent record = new SysEvent();
                        record.setMethod(request.getMethod());
                        record.setRequestUri(path);
                        record.setClientHost(clientIp);
                        record.setUserAgent(userAgent);
                        if (path.contains("/upload")) {
                            record.setParameters("");
                        } else {
                            record.setParameters(JSON.toJSONString(WebUtil.getParameter(request)));
                        }
                        record.setStatus(response.getStatus());
                        if (uid != null) {
                            record.setCreateBy(Long.parseLong(uid.toString()));
                            record.setUpdateBy(Long.parseLong(uid.toString()));
                        }
                        final String msg = (String)request.getAttribute("msg");
                        try {
                            HandlerMethod handlerMethod = (HandlerMethod)handler;
                            ApiOperation apiOperation = handlerMethod.getMethod().getAnnotation(ApiOperation.class);
                            if (apiOperation != null) {
                                record.setTitle(apiOperation.value());
                            }
                        }
                        catch (Exception e) {
                            logger.error("", (Throwable)e);
                        }
                        this.executorService.execute(new Runnable(){

                            @Override
                            public void run() {
                                try {
                                    if (StringUtils.isNotBlank((CharSequence)msg)) {
                                        record.setRemark(msg);
                                    } else {
                                        record.setRemark(ExceptionUtil.getStackTraceAsString(ex));
                                    }
                                    EventInterceptor.this.saveEvent(record);
                                }
                                catch (Exception e) {
                                    BaseInterceptor.logger.error("Save event log cause error :", (Throwable)e);
                                }
                            }
                        });
                        break block15;
                    }
                    if (path.contains("/unauthorized")) {
                        logger.warn("The user [{}] no login", (Object)(clientIp + "@" + userAgent));
                    } else if (path.contains("/forbidden")) {
                        logger.warn("The user [{}] no promission", (Object)(WebUtil.getCurrentUser(request) + "@" + clientIp + "@" + userAgent));
                    } else {
                        logger.info(uid + "@" + path + "@" + clientIp + userAgent);
                    }
                }
                catch (Throwable e) {
                    logger.error("", e);
                }
            }
        }
        String message = "Starttime: {}; Endtime: {}; Used time: {}s; URI: {}; ";
        logger.debug(message, (Object)DateUtil.format(startTime, "HH:mm:ss.SSS"), (Object)DateUtil.format(endTime, "HH:mm:ss.SSS"), (Object)String.valueOf((double)(endTime - startTime) / 1000.0), (Object)path);
        super.afterCompletion(request, response, handler, ex);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void saveEvent(SysEvent record) {
        Class<EventInterceptor> clazz = EventInterceptor.class;
        synchronized (EventInterceptor.class) {
            if (this.sysEventService == null) {
                Map<String, IBaseService> map = ApplicationContextHolder.getBeansOfType(IBaseService.class);
                for (String key : map.keySet()) {
                    if (!key.toLowerCase().contains("sysevent")) continue;
                    this.sysEventService = map.get(key);
                }
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            this.sysEventService.update(record);
            return;
        }
    }
}

