/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.filter;

import com.alibaba.fastjson.JSON;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.ibase4j.core.util.DataUtil;
import top.ibase4j.core.util.FileUtil;
import top.ibase4j.core.util.WebUtil;

public class XssFilter
implements Filter {
    private Logger logger = LogManager.getLogger();
    private List<String> excludeUrls = new ArrayList<String>();
    private List<String> noticeUrls = new ArrayList<String>();

    public void init(FilterConfig filterconfig1) throws ServletException {
        this.logger.info("init XssFilter..");
        String path = XssFilter.class.getResource("/").getFile();
        this.excludeUrls = FileUtil.readFile(path + "white/xssWhite.txt");
    }

    public void doFilter(ServletRequest arg0, ServletResponse arg1, FilterChain arg2) throws IOException, ServletException {
        HttpServletRequest req = (HttpServletRequest)arg0;
        HttpServletResponse response = (HttpServletResponse)arg1;
        String pathInfo = req.getPathInfo() == null ? "" : req.getPathInfo();
        String url = req.getServletPath() + pathInfo;
        String uri = req.getRequestURI();
        boolean isNoticeUrl = false;
        if (WebUtil.isWhiteRequest(uri, this.excludeUrls.size(), this.excludeUrls)) {
            this.logger.info("\u8be5URL\u4e0d\u4f5c\u6821\u9a8c\uff1a" + url);
            arg2.doFilter((ServletRequest)req, (ServletResponse)response);
            return;
        }
        for (String st : this.noticeUrls) {
            if (uri.indexOf(st) < 0) continue;
            isNoticeUrl = true;
            break;
        }
        this.logger.info("doFilter===>{}", (Object)url);
        Map<String, Object> params = WebUtil.getParameterMap(req);
        this.logger.info("request parameters===>{}", (Object)JSON.toJSONString(params));
        String paramN = null;
        for (String key : params.keySet()) {
            if ("sign".equals(key)) {
                this.logger.info("\u8df3\u8fc7\u7b7e\u540d\u5b57\u6bb5");
                continue;
            }
            Object value = params.get(key);
            if (value == null || !(value instanceof String)) continue;
            String paramVale = value.toString();
            if (key.toLowerCase().contains("password")) continue;
            if (isNoticeUrl) {
                paramVale = DataUtil.xssEncode(paramVale);
            }
            if (!this.checkSQLInject(paramVale, url)) continue;
            this.errorResponse(response, paramN);
            return;
        }
        arg2.doFilter((ServletRequest)req, (ServletResponse)response);
    }

    private void errorResponse(HttpServletResponse response, String paramNm) throws IOException {
        String warning = "\u8f93\u5165\u9879\u4e2d\u4e0d\u80fd\u5305\u542b\u975e\u6cd5\u5b57\u7b26\u3002";
        response.setContentType("text/html; charset=UTF-8");
        PrintWriter out = response.getWriter();
        out.println("{\"code\":\"309\",\"msg\":\"" + warning + "\", \"fieldName\": \"" + paramNm + "\"}");
        out.flush();
        out.close();
    }

    public void destroy() {
        this.logger.info("destroy XssFilter.");
    }

    private boolean checkSQLInject(String str, String url) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return false;
        }
        if (DataUtil.checkSQLInject(str)) {
            this.logger.info("xss\u9632\u653b\u51fb\u62e6\u622aurl:" + url + "\uff0c\u539f\u56e0\uff1a\u7279\u6b8a\u5b57\u7b26\uff0c\u4f20\u5165str=" + str);
            return true;
        }
        return false;
    }
}

