/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.filter;

import java.io.IOException;
import java.io.PrintWriter;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.ibase4j.core.util.FileUtil;
import top.ibase4j.core.util.WebUtil;

public class CsrfFilter
implements Filter {
    private Logger logger = LogManager.getLogger();
    private List<String> whiteUrls;
    private int _size = 0;

    public void init(FilterConfig filterConfig) {
        this.logger.info("init CsrfFilter..");
        String path = CsrfFilter.class.getResource("/").getFile();
        this.whiteUrls = FileUtil.readFile(path + "white/csrfWhite.txt");
        this._size = null == this.whiteUrls ? 0 : this.whiteUrls.size();
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            HttpServletRequest req = (HttpServletRequest)request;
            HttpServletResponse res = (HttpServletResponse)response;
            String url = req.getRequestURL().toString();
            String referurl = req.getHeader("Referer");
            if (!WebUtil.isWhiteRequest(referurl, this._size, this.whiteUrls)) {
                req.getRequestDispatcher("/").forward((ServletRequest)req, (ServletResponse)res);
                String log = "";
                String date = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
                String clientIp = WebUtil.getHost(req);
                log = "\u8de8\u7ad9\u8bf7\u6c42---->>>" + clientIp + "||" + date + "||" + referurl + "||" + url;
                this.logger.warn(log);
                response.setContentType("text/html; charset=UTF-8");
                PrintWriter out = response.getWriter();
                out.println("{\"code\":\"308\",\"msg\":\"\u9519\u8bef\u7684\u8bf7\u6c42\u5934\u4fe1\u606f\"}");
                out.flush();
                out.close();
                return;
            }
            chain.doFilter(request, response);
        }
        catch (Exception e) {
            this.logger.error("doFilter", (Throwable)e);
        }
    }

    public void destroy() {
        this.logger.info("destroy CsrfFilter.");
    }
}

