/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.config;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.config.PropertiesFactoryBean;
import org.springframework.boot.SpringApplication;
import org.springframework.boot.env.EnvironmentPostProcessor;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.Ordered;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MutablePropertySources;
import org.springframework.core.env.PropertiesPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.Resource;
import org.springframework.core.io.support.PathMatchingResourcePatternResolver;
import top.ibase4j.core.util.DataUtil;
import top.ibase4j.core.util.InstanceUtil;
import top.ibase4j.core.util.PropertiesUtil;
import top.ibase4j.core.util.SecurityUtil;

@Configuration
public class Configs
implements EnvironmentPostProcessor,
Ordered {
    private Logger logger = LogManager.getLogger();

    public void postProcessEnvironment(ConfigurableEnvironment environment, SpringApplication application) {
        MutablePropertySources propertySources = environment.getPropertySources();
        Properties props = this.getConfig();
        propertySources.addLast((PropertySource)new PropertiesPropertySource("thirdEnv", props));
        for (PropertySource propertySource : propertySources) {
            if (!(propertySource.getSource() instanceof Map)) continue;
            Map map = (Map)propertySource.getSource();
            for (Object key : map.keySet()) {
                String keyStr = key.toString();
                Object value = map.get(key);
                if ("druid.password,druid.writer.password,druid.reader.password".contains(keyStr)) {
                    String dkey = (String)map.get("druid.key");
                    dkey = DataUtil.isEmpty(dkey) ? "90139119" : dkey;
                    value = SecurityUtil.decryptDes(value.toString(), dkey.getBytes());
                    map.put(key, value);
                }
                PropertiesUtil.getProperties().put(keyStr, value.toString());
            }
        }
        System.out.println("* iBase4J Read configuration file finished.");
        this.logger.info("* iBase4J Read configuration file finished.");
    }

    public int getOrder() {
        return -2147483637;
    }

    private Properties getConfig() {
        try {
            PropertiesFactoryBean config = new PropertiesFactoryBean();
            PathMatchingResourcePatternResolver resolver = new PathMatchingResourcePatternResolver();
            ArrayList<Resource> resouceList = InstanceUtil.newArrayList();
            try {
                Resource[] resources;
                for (Resource resource : resources = resolver.getResources("classpath*:config/*.properties")) {
                    resouceList.add(resource);
                }
            }
            catch (Exception e) {
                this.logger.error("", (Throwable)e);
            }
            config.setLocations(resouceList.toArray(new Resource[0]));
            config.afterPropertiesSet();
            return config.getObject();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
        String encrypt = SecurityUtil.encryptDes("root", "90139119".getBytes());
        System.out.println(encrypt);
        System.out.println(SecurityUtil.decryptDes(encrypt, "90139119".getBytes()));
    }
}

