/*
 * Decompiled with CFR 0.152.
 */
package top.ibase4j.core.base.provider;

import java.util.Date;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.ui.ModelMap;
import top.ibase4j.core.base.BaseModel;
import top.ibase4j.core.base.provider.BaseController;
import top.ibase4j.core.base.provider.IBaseProvider;
import top.ibase4j.core.base.provider.Parameter;
import top.ibase4j.core.util.InstanceUtil;

public abstract class AppBaseController<T extends IBaseProvider>
extends BaseController<T> {
    protected final Logger logger = LogManager.getLogger(this.getClass());
    @Autowired
    protected T provider;

    @Override
    protected Long getCurrUser(HttpServletRequest request) {
        Object id = request.getAttribute("CURRENT_USER");
        if (id == null) {
            return null;
        }
        return Long.parseLong(id.toString());
    }

    public Object update(HttpServletRequest request, BaseModel param) {
        return this.update(request, new ModelMap(), param);
    }

    public Object update(HttpServletRequest request, ModelMap modelMap, BaseModel param) {
        Long userId = this.getCurrUser(request);
        if (param.getId() == null) {
            param.setCreateBy(userId);
            param.setCreateTime(new Date());
        }
        param.setUpdateBy(userId);
        param.setUpdateTime(new Date());
        Parameter parameter = new Parameter(this.getService(), "update", param);
        this.logger.info("{} execute update start...", (Object)parameter.getNo());
        Object record = this.provider.execute(parameter).getResult();
        this.logger.info("{} execute update end.", (Object)parameter.getNo());
        HashMap<String, Integer> result = InstanceUtil.newHashMap("bizeCode", 1);
        result.put("record", (Integer)record);
        return this.setSuccessModelMap(modelMap, result);
    }
}

